/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.core.reboot.SafeReboot;
import fxterm.core.update.UpdateUtils;
import fxterm.core.update.WrongReferencesException;
import fxterm.module.Module;
import fxterm.module.input.ExitModuleListener;
import fxterm.session.Session;
import javafx.scene.control.ProgressBar;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.util.TerminalPlatform;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateSystem;
import ru.softlogic.update.updater.exceptions.CreateStoreException;

public class ConsoleNetworkUpdater {
    private final Module module;
    private final Logger log;
    private final ProgressBar progressBar;
    private boolean active;

    public ConsoleNetworkUpdater(Module module, Logger log, ProgressBar progressBar) {
        this.module = module;
        this.log = log;
        this.progressBar = progressBar;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.log.info((Object)("Set console active: " + active));
    }

    public void checkUpdate() {
        try {
            UpdateRequest ur = UpdateUtils.createAppUpdateRequest(new GuiUpdateControl(), new GuiStateListener());
            if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
                Dialog.show((String)"module/utility/console/update_error_busy");
            } else {
                this.progressBar.setProgress(-1.0);
            }
        }
        catch (WrongReferencesException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            Dialog.show((String)"module/utility/console/update_error_refs");
        }
        catch (CreateStoreException ex) {
            GuiNotifier.notifyError((Throwable)ex);
            Dialog.show((String)"module/utility/console/update_error_unknown");
        }
    }

    private void stopProgress() {
        TerminalPlatform.runLater(() -> this.progressBar.setProgress(0.0));
    }

    private class GuiStateListener
    implements StateListener {
        private GuiStateListener() {
        }

        public void onStart() {
            ConsoleNetworkUpdater.this.log.info((Object)"Start update");
        }

        public void onSkip() {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)"No update avaliable");
            if (ConsoleNetworkUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_result_skip"));
            }
        }

        public void onConfirm(UpdateSize updateSize) {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)"Update confirmed");
        }

        public boolean onSuccess(UpdateMetric updateMetric) {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)("Update success: " + updateMetric));
            SafeReboot.exit(17, 3);
            if (ConsoleNetworkUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_result_success", (DialogListener)new ExitModuleListener(ConsoleNetworkUpdater.this.module)));
            }
            return true;
        }

        public void onCancel() {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)"Update cancel");
        }

        public void onLocalError(Exception ex, UpdateMetric updateMetric) {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)"Local error", (Throwable)ex);
            if (ConsoleNetworkUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_error_local"));
            }
        }

        public void onGlobalError(Exception ex) {
            ConsoleNetworkUpdater.this.stopProgress();
            ConsoleNetworkUpdater.this.log.info((Object)"Global error", (Throwable)ex);
            if (ConsoleNetworkUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_error_global"));
            }
        }

        public void onProgress(String fileName, int total, int progress) {
            TerminalPlatform.runLater(() -> ConsoleNetworkUpdater.this.progressBar.setProgress((double)progress * 1.0 / (double)total));
        }
    }

    private class GuiUpdateControl
    implements UpdateControl {
        private GuiUpdateControl() {
        }

        public boolean confirmUpdate(int size) {
            ConsoleNetworkUpdater.this.log.info((Object)("Update size=" + size + ", needs to confirm"));
            Session.setItem("update_size", "" + size / 1024);
            return Dialog.showAndWait((String)"module/utility/console/update_proc_confirm") == 0;
        }

        public boolean confirmRetry(int errorCount, Exception ex) {
            return errorCount < 5;
        }
    }
}

