/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import fxterm.app.FxEnv;
import fxterm.core.BaseScreenListener;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.task.Task;
import fxterm.core.update.UpdateUtils;
import fxterm.core.update.WrongReferencesException;
import fxterm.module.Module;
import fxterm.module.input.ExitModuleListener;
import fxterm.module.input.InitModuleHelper;
import fxterm.session.Session;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javafx.scene.control.ProgressBar;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.util.TerminalPlatform;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateSystem;

public class ConsoleLocalUpdater {
    private static final String UPDATE_FILE = "updatefile";
    private final Module module;
    private final Logger log;
    private final ProgressBar progressBar;
    private boolean active;

    public ConsoleLocalUpdater(Module module, Logger log, ProgressBar progressBar) {
        this.module = module;
        this.log = log;
        this.progressBar = progressBar;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.log.info((Object)("Set console active: " + active));
    }

    public void checkUpdate() {
        this.log.info((Object)"Start search update files");
        new SearchingTask().process();
    }

    private void showSelector(File[] files, ScreenListener sl) {
        SelectorField sf = new SelectorField();
        sf.setId("file");
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (File file : files) {
            String absolutePath = file.getParentFile().getAbsolutePath();
            SelectorItem si = new SelectorItem(absolutePath, absolutePath);
            si.setCustomData(Collections.singletonMap(UPDATE_FILE, file));
            items.add(si);
        }
        sf.setStore((ItemsStore)new StaticStore(items));
        try {
            CommonScreen cs = ScreenStore.getCommonScreen((String)"@selector/list");
            FieldSequence fs = new FieldSequence();
            fs.setFields(Arrays.asList(sf));
            ScreenDescription sd = new ScreenDescription();
            sd.setSequence(fs);
            cs.init(sd, InitModuleHelper.createScreenInit());
            FxEnv.getCustomModule().show(cs, sl, 45);
        }
        catch (ScreenCreateException | InitException ex) {
            this.log.error((Object)"Error on open cbc screen", ex);
            GuiNotifier.notifyError((Throwable)ex);
        }
    }

    private void stopProgress() {
        TerminalPlatform.runLater(() -> this.progressBar.setProgress(0.0));
    }

    private class GuiUpdateControl
    implements UpdateControl {
        private GuiUpdateControl() {
        }

        public boolean confirmUpdate(int size) {
            ConsoleLocalUpdater.this.log.info((Object)("Update size=" + size + ", needs to confirm"));
            Session.setItem("update_size", "" + size / 1024);
            return true;
        }

        public boolean confirmRetry(int errorCount, Exception ex) {
            return errorCount < 5;
        }
    }

    private class GuiStateListener
    implements StateListener {
        private GuiStateListener() {
        }

        public void onStart() {
            ConsoleLocalUpdater.this.log.info((Object)"Start update");
        }

        public void onSkip() {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)"No update avaliable");
            if (ConsoleLocalUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_result_skip"));
            }
        }

        public void onConfirm(UpdateSize updateSize) {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)"Update confirmed");
        }

        public boolean onSuccess(UpdateMetric updateMetric) {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)("Update success: " + updateMetric));
            SafeReboot.exit(17, 3);
            if (ConsoleLocalUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_result_success", (DialogListener)new ExitModuleListener(ConsoleLocalUpdater.this.module)));
            }
            return true;
        }

        public void onCancel() {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)"Update cancel");
        }

        public void onLocalError(Exception ex, UpdateMetric updateMetric) {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)"Local error", (Throwable)ex);
            if (ConsoleLocalUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_error_local"));
            }
        }

        public void onGlobalError(Exception ex) {
            ConsoleLocalUpdater.this.stopProgress();
            ConsoleLocalUpdater.this.log.info((Object)"Global error", (Throwable)ex);
            if (ConsoleLocalUpdater.this.active) {
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_error_global"));
            }
        }

        public void onProgress(String fileName, int total, int progress) {
            TerminalPlatform.runLater(() -> ConsoleLocalUpdater.this.progressBar.setProgress((double)progress * 1.0 / (double)total));
        }
    }

    private class SeletListener
    extends BaseScreenListener {
        private SeletListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ConsoleLocalUpdater.this.log.info((Object)("Action on selecrot screen: " + action));
            if (ActionType.isNext((String)action)) {
                File selectFile = (File)data.get(ConsoleLocalUpdater.UPDATE_FILE);
                ConsoleLocalUpdater.this.log.info((Object)("Select file: " + selectFile.getAbsolutePath()));
                try {
                    UpdateRequest ur = UpdateUtils.createAppUpdateRequest(selectFile.getParentFile(), new GuiUpdateControl(), new GuiStateListener());
                    if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
                        Dialog.show((String)"module/utility/console/update_error_busy");
                    } else {
                        ConsoleLocalUpdater.this.progressBar.setProgress(-1.0);
                    }
                }
                catch (WrongReferencesException ex) {
                    GuiNotifier.notifyError((Throwable)ex);
                    Dialog.show((String)"module/utility/console/update_error_refs");
                }
            }
        }
    }

    private class SearchingTask
    extends Task {
        private SearchingTask() {
        }

        @Override
        protected String getWaitId() {
            return "wait";
        }

        protected Object execute() throws Exception {
            return UpdateUtils.getListLocalUpdates();
        }

        protected void onResult(Object object) {
            File[] updates = (File[])object;
            if (updates.length > 0) {
                ConsoleLocalUpdater.this.log.info((Object)("Show selector update files: " + updates.length));
                ConsoleLocalUpdater.this.showSelector(updates, new SeletListener());
            } else {
                ConsoleLocalUpdater.this.log.info((Object)"Update files not founded");
                TerminalPlatform.runLater(() -> Dialog.show((String)"module/utility/console/update_error_search"));
            }
        }

        @Override
        protected void onError(Exception ex) {
        }

        public String toString() {
            return "SearchingTask{}";
        }
    }
}

