/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.update;

import org.apache.log4j.Logger;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateSize;

public abstract class BaseUpdateStateListener
implements StateListener {
    private final ClientInterface server;
    private final short updateType;
    private final Logger log;
    private short currentState = (short)-1;

    public BaseUpdateStateListener(ClientInterface server, short updateType, Logger log) {
        if (server == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.server = server;
        this.updateType = updateType;
        this.log = log;
    }

    public final void onStart() {
        this.updateState((short)1);
        this._onStart();
    }

    public final void onSkip() {
        this.updateState((short)2);
        this._onSkip();
    }

    public final void onConfirm(UpdateSize updateSize) {
        this.server.sendEvent(new Event[]{new Event(EventType.Update, "Confirm " + this.getType() + " update: size=" + updateSize.getSize() / 1024 + " kB, count=" + updateSize.getCount())});
        this._onConfirm(updateSize);
    }

    public final void onProgress(String fileName, int total, int progress) {
        this._onProgress(fileName, total, progress);
    }

    public final boolean onSuccess(UpdateMetric updateMetric) {
        this.updateState((short)2);
        String duration = String.format("%.2f", (double)updateMetric.getDuration() * 1.0 / 1000.0);
        String speed = String.format("%.2f", (double)updateMetric.getSize() * 1.0 / 1024.0 * 1000.0 / (double)updateMetric.getDuration());
        this.server.sendEvent(new Event[]{new Event(EventType.Update, "Update " + this.getType() + " success: size=" + updateMetric.getSize() / 1024 + " kB, count=" + updateMetric.getCount() + ", duration=" + duration + " s, speed=" + speed + " kBps")});
        return this._onSuccess(updateMetric);
    }

    public final void onCancel() {
        this.updateState((short)3);
        this._onCancel();
    }

    public final void onLocalError(Exception ex, UpdateMetric updateMetric) {
        this.updateState((short)3);
        this._onLocalError(ex, updateMetric);
    }

    public final void onGlobalError(Exception ex) {
        this.updateState((short)3);
        this.server.sendEvent(new Event[]{new Event(EventType.UpdateFault, "Update " + this.getType() + " failure: " + ex.getMessage())});
        this._onGlobalError(ex);
    }

    public void updateState(short state) {
        if (this.currentState != state) {
            this.log.info((Object)("Remote " + this.getType() + " state is change: " + this.currentState + "->" + state));
            this.currentState = state;
            this.server.sendUpdateState(new UpdateState(this.updateType, state));
        }
    }

    private String getType() {
        switch (this.updateType) {
            case 0: {
                return "app";
            }
            case 2: {
                return "dat";
            }
            case 1: {
                return "ban";
            }
        }
        return "unk";
    }

    abstract void _onStart();

    abstract void _onSkip();

    abstract void _onConfirm(UpdateSize var1);

    abstract void _onProgress(String var1, int var2, int var3);

    abstract boolean _onSuccess(UpdateMetric var1);

    abstract void _onCancel();

    abstract void _onLocalError(Exception var1, UpdateMetric var2);

    abstract void _onGlobalError(Exception var1);
}

