/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.task;

import fxterm.app.id.LoggerId;
import fxterm.core.task.ObservableTaskExecutor;
import fxterm.core.task.StateListener;
import fxterm.core.task.Task;
import org.apache.log4j.Logger;
import plfx.shell2.wait.WaitControl;
import plfx.shell2.wait.WaitModule;
import plfx.util.TerminalPlatform;

public class FxTaskExecutor
implements ObservableTaskExecutor,
Runnable {
    private WaitModule waitModule;
    private Task task;
    private StateListener listener;
    private WaitControl control;
    private final Logger log = LoggerId.DEBUG;
    private final Object sync = new Object();
    private boolean done;

    public FxTaskExecutor(WaitModule waitModule) {
        if (waitModule == null) {
            throw new NullPointerException("WaitModule");
        }
        this.waitModule = waitModule;
    }

    @Override
    public synchronized void execute(Task newTask) {
        if (newTask == null) {
            throw new NullPointerException("Task is not set");
        }
        if (this.task != null) {
            throw new IllegalStateException("Last task is not process: " + this.task.getWaitId());
        }
        this.log.info((Object)"=============================================================================");
        this.log.info((Object)("FxTaskExecutor: execute " + newTask.getWaitId() + ", " + newTask.toString()));
        this.task = newTask;
        this.notifyAll();
    }

    @Override
    public void setListener(StateListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                FxTaskExecutor fxTaskExecutor = this;
                synchronized (fxTaskExecutor) {
                    if (this.task == null) {
                        this.wait();
                    }
                }
                Task local = this.task;
                this.log.info((Object)"Start task, notify state listener");
                if (this.listener != null) {
                    this.listener.onStart();
                }
                TerminalPlatform.runLater((Runnable)new Shower(this.task.getWaitId()));
                this.log.info((Object)"Execute process");
                this.done = false;
                try {
                    Object object = local.execute();
                    this.log.info((Object)"Complete");
                    this.log.debug((Object)("Result: " + object));
                    this.complete();
                    this.log.info((Object)"Hide wait & report result");
                    TerminalPlatform.runLater((Runnable)new ResultRunner(local, object));
                }
                catch (Exception ex) {
                    this.log.info((Object)"Error on executing task", (Throwable)ex);
                    this.complete();
                    this.log.info((Object)"Hide wait & report error");
                    TerminalPlatform.runLater((Runnable)new ErrorRunner(local, ex));
                }
                catch (Throwable ex) {
                    this.log.info((Object)"Unknown error on executing task", ex);
                    this.complete();
                    this.log.info((Object)"Hide wait & report error");
                    TerminalPlatform.runLater((Runnable)new ErrorRunner(local, new Exception(ex)));
                }
                Object object = this.sync;
                synchronized (object) {
                    if (!this.done) {
                        this.sync.wait();
                    }
                }
                this.log.info((Object)"Process done");
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable ex) {
                this.log.error((Object)"Error on executing task", ex);
            }
        }
        this.log.info((Object)"Stop thread");
    }

    private synchronized void complete() {
        this.log.debug((Object)"Notify state listener");
        if (this.listener != null) {
            this.listener.onComplete();
        }
        this.log.debug((Object)"Remove task");
        this.task = null;
        this.log.debug((Object)"Done");
    }

    private class ErrorRunner
    implements Runnable {
        private final Task task;
        private final Exception exception;

        public ErrorRunner(Task task, Exception exception) {
            this.task = task;
            this.exception = exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FxTaskExecutor.this.control.close();
            FxTaskExecutor.this.log.info((Object)"Notify result");
            this.task.onError(this.exception);
            FxTaskExecutor.this.log.info((Object)"Done");
            Object object = FxTaskExecutor.this.sync;
            synchronized (object) {
                FxTaskExecutor.this.done = true;
                FxTaskExecutor.this.sync.notifyAll();
            }
        }
    }

    private class ResultRunner
    implements Runnable {
        private final Task task;
        private final Object object;

        public ResultRunner(Task task, Object object) {
            this.task = task;
            this.object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FxTaskExecutor.this.control.close();
            }
            catch (Throwable ex) {
                FxTaskExecutor.this.log.error((Object)("Error on hide wait screen: " + this.task.toString() + ", "), ex);
            }
            FxTaskExecutor.this.log.info((Object)("Notify result: " + this.task.toString()));
            try {
                this.task.onResult(this.object);
            }
            catch (Exception ex) {
                FxTaskExecutor.this.log.error((Object)("Error on notify result: " + this.task.toString() + ", "), (Throwable)ex);
            }
            FxTaskExecutor.this.log.info((Object)"Done");
            Object object = FxTaskExecutor.this.sync;
            synchronized (object) {
                FxTaskExecutor.this.done = true;
                FxTaskExecutor.this.sync.notifyAll();
            }
        }
    }

    private class Shower
    implements Runnable {
        private final String id;

        public Shower(String id) {
            this.id = id;
        }

        @Override
        public void run() {
            FxTaskExecutor.this.control = FxTaskExecutor.this.waitModule.show(this.id);
        }
    }
}

