/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.system;

import com.sun.management.OperatingSystemMXBean;
import fxterm.core.system.FileComparator;
import fxterm.core.system.LinuxSystem;
import fxterm.core.system.WindowsSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javafx.collections.ObservableList;
import javafx.stage.Screen;
import org.apache.commons.io.FileUtils;
import plfx.skin.Skin;
import plfx.skin.SkinException;
import plfx.skin.SkinProperties;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.security.RiskFactors;
import ru.softlogic.security.Service;
import ru.softlogic.security.SystemChecker;
import ru.softlogic.srv.api.oth.FileInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.security.SystemService;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.hwd.SerialExtractorApi;

public class PcInfoCollector {
    public static SystemInfo getPcInfo() {
        SystemInfo si = OsDetector.current() == 2 ? WindowsSystem.getPcInfo() : LinuxSystem.getPcInfo();
        PcInfoCollector.setCommonInfo(si);
        return si;
    }

    public static EnvRiskFactors getEvnRiskFactors() {
        RiskFactors rf = SystemChecker.check();
        LinkedList<FileInfo> infos = new LinkedList<FileInfo>();
        LinkedList<SystemService> ssrvs = new LinkedList<SystemService>();
        for (Service s : rf.getServices()) {
            File f = s.getDriver();
            if (!f.canRead()) continue;
            infos.add(new FileInfo(s.getDriver().getAbsolutePath(), s.getDriver().length(), s.getDriver().lastModified(), PcInfoCollector.calculateChecksum(s.getDriver())));
            ssrvs.add(new SystemService(s.getName(), s.getDescription(), f));
        }
        return new EnvRiskFactors(rf.getFactors(), infos.toArray(new FileInfo[infos.size()]), ssrvs.toArray(new SystemService[ssrvs.size()]), rf.getPorts());
    }

    private static void setCommonInfo(SystemInfo info) {
        String mb2;
        String name2;
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        info.setOsType(OsDetector.current());
        info.setJavaVersion(System.getProperty("java.version"));
        info.setFxVersion(System.getProperty("javafx.runtime.version"));
        info.setMemSize((int)(bean.getTotalPhysicalMemorySize() / 1024L / 1024L));
        info.setSwapSize((int)(bean.getTotalSwapSpaceSize() / 1024L / 1024L));
        info.setHddSerial(SerialExtractorApi.getInstance().getHddSerial());
        info.setAppVersion(DaemonVersion.version + "/" + DaemonUtil.getUpdateBuild());
        info.setAppMem((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        info.setHomePath(PathUtils.getAppHome());
        try {
            name2 = Skin.getWorkSkin();
            SkinProperties sp = Skin.readProperties((String)name2);
            info.setSkinVersion(name2 + "/" + sp.getVersion());
        }
        catch (SkinException name2) {
            // empty catch block
        }
        try {
            String cores;
            String cpu = FileUtils.readFileToString((File)PathUtils.getFilePath((String)"/res/dmi//cpu"), (String)"UTF-8");
            info.setCpuName(PcInfoCollector.readParam(cpu, "Version: (.+)"));
            String speed = PcInfoCollector.readParam(cpu, "Current Speed: (\\d+) MHz");
            if (speed != null && speed.matches("^\\d+$")) {
                info.setCpuFreq(Short.parseShort(speed));
            }
            if ((cores = PcInfoCollector.readParam(cpu, "Core Count: (\\d+)")) != null && cores.matches("^\\d+$")) {
                info.setCpuCount((int)Short.parseShort(cores));
            }
        }
        catch (IOException cpu) {
            // empty catch block
        }
        if (info.getCpuName() == null || info.getCpuName().trim().isEmpty()) {
            String procName = SerialExtractorApi.getInstance().getProcessorName();
            info.setCpuName(procName == null ? null : procName.trim());
        }
        if (info.getCpuCount() == 0) {
            info.setCpuCount(bean.getAvailableProcessors());
        }
        try {
            mb2 = FileUtils.readFileToString((File)PathUtils.getFilePath((String)"/res/dmi//motherboard"), (String)"UTF-8");
            info.setMbVendor(PcInfoCollector.readParam(mb2, "Manufacturer: (.+)"));
            info.setMbModel(PcInfoCollector.readParam(mb2, "Product Name: (.+)"));
            info.setMbSerial(PcInfoCollector.readParam(mb2, "Serial Number: (.+)"));
        }
        catch (IOException mb2) {
            // empty catch block
        }
        try {
            name2 = FileUtils.readFileToString((File)PathUtils.getFilePath((String)"/res/dmi//video"), (String)"UTF-8").trim();
            if (name2.matches("^.*VGA compatible controller:.*$")) {
                name2 = PcInfoCollector.readParam(name2, ".*VGA compatible controller: (.+)");
            }
            info.setVideoCard(name2.replaceAll("\\p{C}", "?"));
        }
        catch (IOException name3) {
            // empty catch block
        }
        try {
            mb2 = FileUtils.readFileToString((File)PathUtils.getFilePath((String)"/res/dmi//mem"), (String)"UTF-8");
            info.setMemFreq(Short.valueOf(Short.parseShort(PcInfoCollector.readParam(mb2, "Speed: (.+) MHz"))));
        }
        catch (IOException | NumberFormatException mb3) {
            // empty catch block
        }
        try {
            ObservableList screens = Screen.getScreens();
            info.setDisplaysCount(screens.size());
            for (int j = 0; j < screens.size() && j < 2; ++j) {
                Screen sc = (Screen)screens.get(j);
                String display = sc.getBounds().getWidth() + "x" + sc.getBounds().getHeight();
                if (j == 0) {
                    info.setDisplay1(display);
                    continue;
                }
                info.setDisplay2(display);
            }
        }
        catch (Exception screens) {
            // empty catch block
        }
        File cnf = PathUtils.getFilePath((String)"/conf.xml");
        info.setCnfCrc(PcInfoCollector.calculateChecksum(cnf));
        info.setCnfModificationDate(new Date(cnf.lastModified()));
        int len = PathUtils.getAppHome().length() + 1;
        LinkedList<FileInfo> files = new LinkedList<FileInfo>();
        for (File f : PcInfoCollector.getFiles()) {
            files.add(new FileInfo(f.getAbsolutePath().substring(len), f.length(), f.lastModified(), PcInfoCollector.calculateChecksum(f)));
        }
        info.setFiles(files.toArray(new FileInfo[files.size()]));
        PcInfoCollector.searchJavaUpdate(info);
    }

    private static String readParam(String data, String ptn) {
        Pattern pattern = Pattern.compile(ptn);
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long calculateChecksum(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            int l2;
            CRC32 cs = new CRC32();
            cs.reset();
            byte[] buf = new byte[1024];
            while ((l2 = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l2);
            }
            long l = cs.getValue();
            return l;
        }
        catch (IOException ex) {
            return 0L;
        }
    }

    private static Collection<File> getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (String f : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (f.endsWith("*")) {
                files.addAll(FileUtils.listFiles((File)PathUtils.getFilePath((String)f.substring(0, f.length() - 1)), null, (boolean)false));
                continue;
            }
            files.add(new File(f));
        }
        files.addAll(FileUtils.listFiles((File)PathUtils.getFilePath((String)"/jni/"), null, (boolean)true));
        files.addAll(FileUtils.listFiles((File)PathUtils.getFilePath((String)"/bin/"), null, (boolean)true));
        File nw = PathUtils.getFilePath((String)"//nw/nw.exe");
        if (nw.canRead()) {
            files.add(nw);
        }
        if ((nw = PathUtils.getFilePath((String)"//nw/nw")).canRead()) {
            files.add(nw);
        }
        return files;
    }

    private static void searchJavaUpdate(SystemInfo systemInfo) {
        File fVer = PathUtils.getFilePath((String)"/jre/work//sl/version");
        if (!fVer.canRead()) {
            return;
        }
        try {
            File patch = PcInfoCollector.getPatch(FileUtils.readFileToString((File)fVer).trim());
            if (patch != null) {
                systemInfo.setJavaHasUpdate(true);
                systemInfo.setJavaPatchName(patch.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getPatch(String curr) {
        File[] files = PathUtils.getFilePath((String)"/jre/").listFiles((dir1, name) -> name.matches("^" + curr + "-[\\d]{4}\\.bpatch$"));
        if (files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        Arrays.sort(files, new FileComparator());
        return files[0];
    }
}

