/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.system.util.OsDetector;

class LinuxSystem {
    LinuxSystem() {
    }

    public static SystemInfo getPcInfo() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        SystemInfo info = new SystemInfo();
        info.setOsType(OsDetector.current());
        info.setKernelVersion(bean.getVersion());
        Properties prop = new Properties();
        try (FileInputStream is = new FileInputStream("/etc/lsb-release");){
            prop.load(is);
            info.setOsName(prop.getProperty("DISTRIB_ID"));
            info.setOsVersion(prop.getProperty("DISTRIB_RELEASE"));
        }
        catch (IOException ex) {
            try {
                String release = FileUtils.readFileToString((File)new File("/etc/redhat-release"));
                String[] paths = release.split(" ");
                if (paths.length >= 3) {
                    info.setOsName(paths[0].trim());
                    info.setOsVersion(paths[2].trim());
                }
            }
            catch (IOException ex1) {
                try {
                    String release = FileUtils.readFileToString((File)new File("/etc/issue")).trim();
                    String[] paths = release.split(" ");
                    if (paths.length >= 3) {
                        info.setOsName(paths[0].trim());
                        info.setOsVersion(paths[2].trim());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return info;
    }
}

