/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.state;

public class TerminalState {
    public static final int OK = 0;
    public static final int ERROR_CASHIN = 1;
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_DISK = 3;
    public static final int ERROR_LOCKED = 4;
    public static final int ERROR_PRINTER = 5;
    public static final int ERROR_REFERENCES = 6;
    public static final int ERROR_REBOOT = 7;
    public static final int ERROR_POWER = 8;
    public static final int ERROR_DISPLAY_OFF = 9;
    public static final int ERROR_GENERIC = 10;
    public static final int ERROR_CDM = 11;
    public static final int ERROR_INKASS_LIMIT = 12;
    public static final int ERROR_SERVICING = 13;
    public static final int FLAG_OK = 0;
    public static final int WARNING_PAPER = 1;
    public static final int WARNING_CASH_ACC = 2;
    public static final int WARNING_COIN_ACC = 4;
    private final int errorCode;
    private final int warningMask;

    public TerminalState(int errorCode, int warningMask) {
        this.errorCode = errorCode;
        this.warningMask = warningMask;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getWarningMask() {
        return this.warningMask;
    }

    public String toString() {
        return "State{errorCode=" + this.errorCode + ", warningMask=" + this.warningMask + '}';
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.errorCode;
        hash = 59 * hash + this.warningMask;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalState other = (TerminalState)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return this.warningMask == other.warningMask;
    }
}

