/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.state;

import fxterm.core.state.TerminalState;
import java.util.ArrayList;
import java.util.Objects;
import java.util.ResourceBundle;

public final class StateMsg {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(StateMsg.class.getPackage().getName() + ".messages");

    private StateMsg() {
    }

    public static String get(String id) {
        try {
            return bundle.getString(id);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public static String getStateTitle(int stateId) {
        return StateMsg.get("state.title." + stateId);
    }

    public static String getFlagsTitle(int flags) {
        return StateMsg.getFlags("flag.title.", flags);
    }

    public static String getStateName(int stateId) {
        return StateMsg.get("state." + stateId);
    }

    public static String getFlagsStr(int flags) {
        return StateMsg.getFlags("flag.", flags);
    }

    public static String getFlags(String code, int flags) {
        if (flags == 0) {
            return StateMsg.get(code + "0");
        }
        ArrayList<String> msg = new ArrayList<String>(3);
        if ((flags & 1) != 0) {
            msg.add(StateMsg.get(code + 1));
        }
        if ((flags & 2) != 0) {
            msg.add(StateMsg.get(code + 2));
        }
        if ((flags & 4) != 0) {
            msg.add(StateMsg.get(code + 4));
        }
        return String.join((CharSequence)",", msg);
    }

    public static String getTerminalState(TerminalState ts) {
        Objects.requireNonNull(ts, "Terminal state is not set");
        return StateMsg.getStateName(ts.getErrorCode()) + ", flags=" + StateMsg.getFlagsStr(ts.getWarningMask());
    }

    public static String getStateRecommendation(TerminalState ts) {
        try {
            return bundle.getString("recommendation." + ts.getErrorCode());
        }
        catch (Exception ex) {
            return "";
        }
    }
}

