/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.state;

import fxterm.core.state.StateFacadeEngine;
import fxterm.core.state.StateListener;
import fxterm.core.state.TerminalState;

public abstract class StateFacade {
    private static StateFacadeEngine engine;

    public static void setEngine(StateFacadeEngine engine) {
        if (StateFacade.engine != null) {
            throw new IllegalStateException("Engine already set");
        }
        StateFacade.engine = engine;
    }

    public static TerminalState getState() {
        if (engine == null) {
            throw new IllegalStateException("Engine is not set");
        }
        return engine.getState();
    }

    public static void addListener(StateListener listener) {
        if (listener == null) {
            throw new NullPointerException("StateListener is not set");
        }
        engine.addListener(listener);
    }

    public static void removeListener(StateListener listener) {
        if (listener == null) {
            throw new NullPointerException("StateListener is not set");
        }
        engine.removeListener(listener);
    }
}

