/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.state;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.app.id.LoggerId;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.state.StateFacadeEngine;
import fxterm.core.state.StateListener;
import fxterm.core.state.StateMsg;
import fxterm.core.state.TerminalState;
import fxterm.core.timer.Timer;
import fxterm.session.Session;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import plfx.util.TerminalPlatform;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.reference.References;
import ru.softlogic.reference.point.DeviceLockingAction;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.srv.connector.NetObserver;
import ru.softlogic.srv.connector.RemoteStatusObserver;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.srv.queue.QueueStatus;
import ru.softlogic.storage.cash.StoreManager;

public class BaseFacadeEngine
implements StateFacadeEngine {
    private Queue queue;
    private DeviceState printerStatus;
    private DeviceState validatorStatus;
    private long validatorUpdated;
    private Boolean locked;
    private CashAccListener cashAccListener;
    private NetworkListener networkListener;
    private PrinterListener printerListener;
    private Long networkErrorTime;
    private long networkErrorCount;
    private boolean networkErrorLogged;
    private TerminalState lastState;
    private final Logger log = LoggerId.LOCKER;
    private Set<StateListener> listeners;
    private Long fraudLockTime;

    public BaseFacadeEngine(Queue queue) {
        if (queue == null) {
            throw new NullPointerException("Queue");
        }
        this.queue = queue;
        this.cashAccListener = new CashAccListener();
        this.networkListener = new NetworkListener();
        this.printerListener = new PrinterListener();
        this.listeners = new HashSet<StateListener>();
    }

    public DeviceStateListener getCashAcceptorListener() {
        return this.cashAccListener;
    }

    public RemoteStatusObserver getNetworkObserver() {
        return this.networkListener;
    }

    public NetObserver getNetworkErrorObserver() {
        return this.networkListener;
    }

    public DeviceStateListener getPrinterListener() {
        return this.printerListener;
    }

    @Override
    public synchronized void addListener(StateListener listener) {
        TerminalState ts = this.getState();
        this.listeners.add(listener);
        listener.onState(ts);
    }

    @Override
    public synchronized void removeListener(StateListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized TerminalState getState() {
        TerminalState state;
        PointOptions po = References.getPointOptions();
        Point p = References.getPoint();
        boolean workWithBrokenFiscal = false;
        int netErrorTimeOption = 0;
        int netErrorCountOption = 0;
        int queueScanTimeout = 0;
        Integer inLimit = null;
        String curr = SystemProp.getDefaultCurrency();
        DeviceLockingAction[] lockingActions = null;
        DeviceLockingAction usedDLA = null;
        if (po != null) {
            workWithBrokenFiscal = po.isWorkWithBrokenFiscal();
            netErrorTimeOption = po.getNotConnectedMinute();
            netErrorCountOption = po.getNotConnectedTry();
            queueScanTimeout = po.getQueueScanTimeout();
            lockingActions = po.getLockingActions();
        }
        QueueStatus qs = this.queue.getStatus(queueScanTimeout);
        if (p != null) {
            inLimit = p.getIncassLimit();
        }
        int errorCode = 0;
        int warningMask = 0;
        Long netErrorTime = this.networkErrorTime;
        if (SafeReboot.isPlanned()) {
            this.log.info((Object)"Planned reboot/shutdown");
            errorCode = 7;
        } else if (Boolean.TRUE.equals(this.locked)) {
            errorCode = 4;
        } else if (po != null && (qs.getSize() > po.getQueueSize() || qs.getTimeout() > (long)po.getQueueTimeout())) {
            this.log.error((Object)MessageFormat.format("Too many stored payments, size={0}(limit={1}), timeout={2}(limit={3})", qs.getSize(), po.getQueueSize(), qs.getTimeout(), po.getQueueTimeout()));
            errorCode = 2;
        } else if (qs.isDiskError()) {
            this.log.error((Object)("Disk error: q=" + qs.isDiskError()));
            errorCode = 3;
        } else if (References.getDealer() == null || References.getPoint() == null || References.getPointOptions() == null || References.getMenu() == null || References.getMenu().getTypes() == null) {
            errorCode = 6;
        } else if (netErrorTimeOption > 0 && netErrorTime != null && (Timer.currentSec() - netErrorTime) / 60L >= (long)netErrorTimeOption) {
            if (!this.networkErrorLogged) {
                this.log.error((Object)("Lock by NetworkErrorTime. " + (Timer.currentSec() - netErrorTime) + " sec. left"));
                this.networkErrorLogged = true;
            }
            errorCode = 2;
        } else if (netErrorCountOption > 0 && this.networkErrorCount >= (long)netErrorCountOption) {
            if (!this.networkErrorLogged) {
                this.log.error((Object)("Lock by NetworkErrorCount. Error counts: " + this.networkErrorCount));
                this.networkErrorLogged = true;
            }
            errorCode = 2;
        } else if (this.validatorStatus != null && !this.validatorStatus.isOk()) {
            boolean cAccError = true;
            if (this.validatorStatus.getState() == 2) {
                boolean bl = cAccError = Timer.currentSec() - this.validatorUpdated > 210L;
            }
            if (cAccError) {
                if (FxEnv.getCoinValidator() != null) {
                    warningMask |= 2;
                } else {
                    errorCode = 1;
                }
            }
            if (this.validatorStatus.getState() == -8) {
                errorCode = 13;
            }
            if (errorCode != 0 && errorCode != 13) {
                usedDLA = this.getDLA(lockingActions, (short)3, (short)1);
                if (usedDLA != null) {
                    if (usedDLA.getAction() == 0) {
                        errorCode = 0;
                    } else if (usedDLA.getAction() == 1) {
                        errorCode = 0;
                        warningMask |= 2;
                    }
                }
            } else if (warningMask != 0 && errorCode != 13 && (usedDLA = this.getDLA(lockingActions, (short)3, (short)0)) != null) {
                if (usedDLA.getAction() == 0) {
                    warningMask &= 0xFFFFFFFD;
                } else if (usedDLA.getAction() == 2) {
                    errorCode = 1;
                }
            }
        } else if (Session.getFraudLock() != null) {
            if (this.fraudLockTime == null) {
                this.fraudLockTime = Timer.currentSec();
            }
            if (Timer.currentSec() - this.fraudLockTime <= (long)Session.getFraudLock().intValue()) {
                errorCode = 1;
            } else {
                Session.setFraudLock(null);
                this.fraudLockTime = null;
            }
        } else if (inLimit != null && this.isExceedCashLimis(inLimit, curr)) {
            errorCode = 12;
        }
        if (errorCode == 0 && this.printerStatus != null && !this.printerStatus.isOk()) {
            usedDLA = this.getDLA(lockingActions, this.printerStatus.getDeviceClass(), (short)1);
            if (usedDLA != null) {
                if (usedDLA.getAction() == 2) {
                    errorCode = 5;
                } else if (usedDLA.getAction() == 1) {
                    warningMask |= 1;
                }
            } else if (this.printerStatus.getDeviceClass() == 2 && !workWithBrokenFiscal) {
                errorCode = 5;
            } else {
                warningMask |= 1;
            }
        }
        if (!(state = new TerminalState(errorCode, warningMask)).equals(this.lastState)) {
            this.lastState = state;
            this.log.info((Object)("Current terminal state: " + state));
            this.log.info((Object)("    State message: " + StateMsg.getTerminalState(state)));
            if (usedDLA != null) {
                this.log.info((Object)("    Use device locking action: " + usedDLA));
            }
            this.notyfyListeners();
        }
        return state;
    }

    private boolean isExceedCashLimis(int limit, String currency) {
        DenominationSet cash = new DenominationSet(StoreManager.getDefaultStore((short)3).getBoxes()[0].getCounts());
        DenominationSet coin = new DenominationSet(StoreManager.getDefaultStore((short)4).getBoxes()[0].getCounts());
        Sum sum = cash.getTotal(currency).add(coin.getTotal(currency));
        return sum.getValue() >= limit;
    }

    private DeviceLockingAction getDLA(DeviceLockingAction[] dlas, short deviceClass, short deviceState) {
        if (dlas == null) {
            return null;
        }
        for (DeviceLockingAction dla : dlas) {
            if (dla == null || dla.getDeviceClass() != deviceClass || dla.getState() != deviceState) continue;
            return dla;
        }
        return null;
    }

    private void notyfyListeners() {
        TerminalPlatform.runLater(() -> this.listeners.forEach(sl -> sl.onState(this.lastState)));
    }

    private class PrinterListener
    implements DeviceStateListener {
        private PrinterListener() {
        }

        public void onState(DeviceState state) {
            BaseFacadeEngine.this.printerStatus = state;
        }
    }

    private class NetworkListener
    implements RemoteStatusObserver,
    NetObserver {
        private NetworkListener() {
        }

        public void update(int remoteStatus) {
            boolean l;
            boolean bl = l = (remoteStatus & 1) != 0;
            if (BaseFacadeEngine.this.locked == null || BaseFacadeEngine.this.locked != l) {
                BaseFacadeEngine.this.log.info((Object)("Get network state: " + remoteStatus));
                BaseFacadeEngine.this.locked = l;
                BaseFacadeEngine.this.getState();
            }
        }

        public void update(boolean netError) {
            if (netError) {
                BaseFacadeEngine.this.networkErrorCount++;
                if (BaseFacadeEngine.this.networkErrorTime == null) {
                    BaseFacadeEngine.this.networkErrorTime = Timer.currentSec();
                }
            } else {
                BaseFacadeEngine.this.networkErrorTime = null;
                BaseFacadeEngine.this.networkErrorCount = 0L;
                BaseFacadeEngine.this.networkErrorLogged = false;
            }
        }
    }

    private class CashAccListener
    implements DeviceStateListener {
        private CashAccListener() {
        }

        public void onState(DeviceState state) {
            if (!state.equals((Object)BaseFacadeEngine.this.validatorStatus)) {
                BaseFacadeEngine.this.log.info((Object)("New validator state: " + state));
                BaseFacadeEngine.this.validatorUpdated = Timer.currentSec();
                BaseFacadeEngine.this.validatorStatus = state;
                TerminalPlatform.runLater(() -> BaseFacadeEngine.this.getState());
            }
        }
    }
}

