/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.save;

import fxterm.app.id.LoggerId;
import fxterm.core.save.CryptoUtils;
import fxterm.core.save.Result;
import fxterm.core.save.SaveObjectException;
import fxterm.core.save.SavingHandler;
import fxterm.core.save.SavingObjectType;
import fxterm.core.save.SavingTask;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.SignedObject;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.queue.utils.ObjectReadWriteStream;

public class SecureSaveUtils {
    private static final Map<SavingObjectType, SavingTask> map = new EnumMap<SavingObjectType, SavingTask>(SavingObjectType.class);
    private static KeyStore keyStore;
    private static final Logger log;

    public static void setKeyStore(KeyStore keyStore) {
        SecureSaveUtils.keyStore = keyStore;
    }

    public static SavingHandler addSavingTask(SavingTask task) {
        map.put(task.getObjectType(), task);
        return object -> SecureSaveUtils.saveObject(task.getObjectType(), object);
    }

    public static Result loadSavedObject(String path, boolean isSigned) throws SaveObjectException {
        Result result;
        ObjectReadWriteStream orwStream;
        block9: {
            Object readObject;
            block7: {
                Serializable serializable;
                block8: {
                    orwStream = null;
                    orwStream = new ObjectReadWriteStream(path);
                    readObject = orwStream.readObject();
                    if (!(readObject instanceof SignedObject)) break block7;
                    log.info((Object)"Object was signed");
                    SignedObject signed = (SignedObject)readObject;
                    serializable = (Serializable)signed.getObject();
                    if (!isSigned || keyStore != null && CryptoUtils.verifyObject(signed, keyStore, log)) break block8;
                    Result result2 = new Result(serializable, 1);
                    IOUtils.closeQuietly((Closeable)orwStream);
                    return result2;
                }
                Result result3 = new Result(serializable, 0);
                IOUtils.closeQuietly((Closeable)orwStream);
                return result3;
            }
            if (!(readObject instanceof Serializable)) break block9;
            log.info((Object)"Object was not signed");
            Result result4 = new Result((Serializable)readObject, 0);
            IOUtils.closeQuietly((Closeable)orwStream);
            return result4;
        }
        try {
            result = null;
        }
        catch (IOException | ClassNotFoundException ex) {
            try {
                log.error((Object)ex, (Throwable)ex);
                throw new SaveObjectException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(orwStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)orwStream);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveObject(SavingObjectType type, Serializable object) {
        ObjectReadWriteStream file;
        block6: {
            block7: {
                SavingTask task = map.get((Object)type);
                if (task == null) break block7;
                file = null;
                try {
                    file = new ObjectReadWriteStream(task.getPath());
                    SignedObject sign = null;
                    if (task.isSigning() && keyStore != null) {
                        sign = CryptoUtils.signObject(object, keyStore, log);
                    }
                    if (sign != null) {
                        file.writeObject(sign);
                        break block6;
                    }
                    file.writeObject(object);
                }
                catch (IOException ex) {
                    boolean bl;
                    try {
                        log.error((Object)ex, (Throwable)ex);
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(file);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)file);
                    return bl;
                }
                break block6;
            }
            log.warn((Object)("Saving tasks list does not contain task type of  " + (Object)((Object)type)));
            return false;
        }
        IOUtils.closeQuietly((Closeable)file);
        return true;
    }

    static {
        log = LoggerId.APP;
    }
}

