/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.save;

import java.io.Serializable;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignedObject;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.apache.log4j.Logger;

public class CryptoUtils {
    private static final String ALG = "DSA";

    public static SignedObject signObject(Serializable object, KeyStore keystore, Logger log) {
        try {
            Signature signature = Signature.getInstance(ALG);
            KeyPair keyPair = CryptoUtils.getKeyPair(keystore, "softlogic", "softlogic_keys");
            PrivateKey privateKey = keyPair.getPrivate();
            return new SignedObject(object, privateKey, signature);
        }
        catch (Exception ex) {
            log.info((Object)("Object signed error. Reason: " + ex.getMessage()));
            return null;
        }
    }

    public static boolean verifyObject(SignedObject object, KeyStore keystore, Logger log) {
        try {
            Signature sig = Signature.getInstance(ALG);
            KeyPair keyPair = CryptoUtils.getKeyPair(keystore, "softlogic", "softlogic_keys");
            PublicKey publicKey = keyPair.getPublic();
            return object.verify(publicKey, sig);
        }
        catch (Exception ex) {
            log.info((Object)("Object verify error. Reason: " + ex.getMessage()));
            return false;
        }
    }

    public static KeyPair getKeyPair(KeyStore keystore, String alias, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey privateKey = (PrivateKey)keystore.getKey(alias, password.toCharArray());
        Certificate cert = keystore.getCertificate(alias);
        PublicKey publicKey = cert.getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }
}

