/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.reboot;

import fxterm.app.id.LoggerId;
import fxterm.core.reboot.CauseIO;
import fxterm.core.reboot.Finalizator;
import fxterm.core.reboot.RebootAction;
import fxterm.module.ModuleStore;
import fxterm.msg.Messages;
import java.time.Duration;
import java.time.Instant;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.FinancialObserver;

public class SafeReboot {
    public static final int ACTION_RESTART = 0;
    public static final int ACTION_SHUTDOWN = 15;
    public static final int ACTION_CONFIGURE = 16;
    public static final int ACTION_UPDATE_APP = 17;
    public static final int ACTION_UPDATE_RES = 18;
    public static final int ACTION_JAVA_UPDATE = 24;
    public static final int ACTION_TERM_REBOOT = 20;
    public static final int ACTION_TERM_SHUTDOWN = 21;
    public static final int CAUSE_UNKNOWN = 0;
    public static final int CAUSE_COMMAND_FROM_SERVER = 1;
    public static final int CAUSE_COMMAND_FROM_CONSOLE = 2;
    public static final int CAUSE_UPDATE_DOWNLOADS = 3;
    public static final int CAUSE_UPDATE_SUCCESS = 4;
    public static final int CAUSE_UPDATE_ERROR = 5;
    public static final int CAUSE_TIME_SYNC = 6;
    public static final int CAUSE_SCHEDULE = 7;
    public static final int CAUSE_RPC_ERROR = 8;
    public static final int CAUSE_NETWORK = 9;
    public static final int CAUSE_ALT_F4 = 10;
    public static final int CAUSE_SOFTWARE_FAULT = 11;
    public static final int CAUSE_SKIN_CHANGE = 12;
    public static final int CAUSE_IDLE = 13;
    private static int action = -1;
    private static int cause;
    private static final Logger log;
    private static Finalizator fin;
    private static int queueSize;
    private static final FinancialObserver observer;

    public static void setFinalizator(Finalizator finalizator) {
        fin = finalizator;
    }

    public static FinancialObserver getObserver() {
        return observer;
    }

    public static synchronized void reboot(int cause) {
        log.info((Object)"Process reboot request");
        SafeReboot.init(20, cause);
    }

    public static synchronized void shutdown(int cause) {
        SafeReboot.init(21, cause);
    }

    public static synchronized void exit(int action, int cause) {
        if (action < 0) {
            throw new IllegalArgumentException("Code must be equals or greater 0");
        }
        SafeReboot.init(action, cause);
    }

    public static boolean isPlanned() {
        return action >= 0;
    }

    private static void init(int action, int cause) {
        log.info((Object)("Try to process action: " + Messages.getActionName(action) + ", cause=" + Messages.getCauseName(cause)));
        if (SafeReboot.isPlanned()) {
            return;
        }
        if (cause < 0 || cause > 20) {
            throw new IllegalArgumentException("Cause must be in range 0..20");
        }
        if (fin == null) {
            throw new IllegalArgumentException("Finalizator is not set");
        }
        log.info((Object)("Process action: " + Messages.getActionName(action) + ", cause=" + Messages.getCauseName(cause)));
        SafeReboot.action = action;
        SafeReboot.cause = cause;
        Thread th = new Thread(new SafeWaiter());
        th.setDaemon(true);
        th.start();
    }

    static {
        log = LoggerId.APP;
        observer = new LocalSizeListener();
    }

    private static class LocalSizeListener
    implements FinancialObserver {
        private LocalSizeListener() {
        }

        public void update(int size) {
            queueSize = size;
        }
    }

    private static class SafeWaiter
    implements Runnable {
        private SafeWaiter() {
        }

        @Override
        public void run() {
            try {
                Duration d;
                int moduleType;
                log.info((Object)"Expect the user navigates to the main menu");
                int count = cause != 11 ? 6000 : 300;
                for (int i = 0; i < count && (moduleType = ModuleStore.getModule().getType()) != 1 && moduleType != 0; ++i) {
                    Thread.sleep(100L);
                }
                Instant start = Instant.now();
                log.info((Object)("FinQueue size: " + queueSize));
                if (queueSize > 0) {
                    log.info((Object)"Wait for send");
                    for (int i = 0; i < 300; ++i) {
                        if (queueSize <= 0) continue;
                        Thread.sleep(100L);
                    }
                    log.info((Object)("Done, current size: " + queueSize));
                }
                if ((d = Duration.between(start, Instant.now())).getSeconds() < 5L && cause != 2 && cause != 11) {
                    log.info((Object)"Sleep for 5 seconds");
                    Thread.sleep(5000L);
                }
                log.info((Object)"Persist action data");
                CauseIO.saveRebootAction(new RebootAction(action, cause));
                fin.finalizeApp(action);
            }
            catch (InterruptedException ex) {
                log.error((Object)ex, (Throwable)ex);
                fin.finalizeApp(action);
                Thread.currentThread().interrupt();
            }
        }
    }
}

