/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.stat;

import fxterm.app.id.LoggerId;
import fxterm.core.net.stat.NetStatHandler;
import fxterm.core.net.stat.NetStatSender;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ClientInterface;

public class NetStatLoader
implements Runnable {
    private static final long INTERVAL = 86400000L;
    private NetStatHandler handler;
    private ClientInterface clientInterface;
    private ScheduledExecutorService service;
    private final Logger log = LoggerId.APP;

    public NetStatLoader(NetStatHandler handler, ClientInterface clientInterface, ScheduledExecutorService service) {
        if (handler == null) {
            throw new NullPointerException("NetStatHandler is null");
        }
        if (clientInterface == null) {
            throw new NullPointerException("ClientInterface is null");
        }
        if (service == null) {
            throw new NullPointerException("ScheduledExecutorService is null");
        }
        this.handler = handler;
        this.clientInterface = clientInterface;
        this.service = service;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start to load network statistic sender");
        Date d = this.handler.getFrom();
        this.log.info((Object)("Last send: " + d));
        long current = new Date().getTime() - d.getTime();
        this.log.info((Object)("Time passed, sec: " + current / 1000L));
        NetStatSender nss = new NetStatSender(this.handler, this.clientInterface);
        long next = 10000L;
        if (current > 0L && current <= 86400000L) {
            next = 86400000L - current;
        }
        this.log.info((Object)("Next launch, sec: " + next / 1000L));
        this.service.scheduleAtFixedRate(nss, next, 86400000L, TimeUnit.MILLISECONDS);
    }
}

