/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.stat;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.connector.NetObserver;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;
import ru.softlogic.storage.io.SimpleSerializator;

public class NetStatHandler
implements NetObserver {
    private final ObjectIO<NetworkStatistics> io;
    private NetworkStatistics stat;

    public NetStatHandler(File file) {
        this.io = new ObjectIO((Serializator)new SimpleSerializator(file));
    }

    public synchronized void update(boolean netError) {
        this.check();
        this.stat.setNetworkTotal(this.stat.getNetworkTotal() + 1);
        if (netError) {
            this.stat.setNetworkError(this.stat.getNetworkError() + 1);
        }
        this.io.write((Serializable)this.stat);
    }

    public synchronized NetworkStatistics resetStatistics() {
        this.check();
        NetworkStatistics res = this.stat;
        res.setTo(new Date());
        this.stat = new NetworkStatistics();
        this.stat.setFrom(new Date());
        this.io.write((Serializable)this.stat);
        return res;
    }

    public synchronized Date getFrom() {
        this.check();
        return this.stat.getFrom();
    }

    private void check() {
        if (this.stat == null) {
            NetworkStatistics ns = new NetworkStatistics();
            ns.setFrom(new Date());
            this.stat = (NetworkStatistics)this.io.read((Serializable)ns);
        }
    }
}

