/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupTask;
import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Api;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.hdw.dev.modem.OpenException;
import ru.softlogic.hdw.dev.modem.Registration;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;
import ru.softlogic.srv.api.command.Command;

public class UssdExecuteTask
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;
    private static final int SLEEP_TIMEOUT = 1000;
    private static final int ATTEMPT_COUNT = 20;
    private static final int ATTEMPT_PAUSE = 500;
    private final Command cmd;
    private String result;
    private final Object sync = new Object();
    private boolean done = false;

    public UssdExecuteTask(Command cmd) {
        this.cmd = Objects.requireNonNull(cmd, "Command is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        boolean needConnect = false;
        if (conn.getState() != 1) {
            this.log.info((Object)"Disconnect dialup");
            conn.disconnect();
            needConnect = true;
            Thread.sleep(1000L);
        }
        try {
            this.processImpl(conn, watchDog, modem);
        }
        catch (DialupException | RPCException ex) {
            this.result = ex.getMessage();
            throw ex;
        }
        finally {
            Object object = this.sync;
            synchronized (object) {
                this.done = true;
                this.sync.notifyAll();
            }
        }
        if (needConnect) {
            this.log.info((Object)"Start dialup connection");
            conn.connect();
        }
        this.log.info((Object)"Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processImpl(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        for (int i = 0; i < 20; ++i) {
            try {
                this.log.info((Object)("Try to open device. Attempt " + i));
                modem.open();
                this.log.info((Object)"Done, init modem");
                Api modemApi = modem.getApi();
                Registration reg = modemApi.getRegistration();
                if (reg.getState() == 1 || reg.getState() == 5) {
                    this.log.info((Object)"Modem is registred");
                    int operId = modemApi.getOperatorId();
                    this.log.info((Object)("operator-id=" + operId));
                    this.result = modemApi.executeUssd(this.cmd.getParam1(), this.cmd.getParam2(), this.cmd.getParam3(), 5000);
                    this.log.error((Object)("USSD-response: " + this.result));
                    break;
                }
                this.log.error((Object)"Modem is not registred in network");
                continue;
            }
            catch (ModemException | OpenException ex) {
                this.log.error((Object)"Error on open modem port", ex);
                if (i == 19) {
                    throw new DialupException(ex);
                }
                Thread.sleep(500L);
                continue;
            }
            finally {
                this.log.info((Object)"Try to close modem");
                modem.close();
                this.log.info((Object)"Close done");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult() throws InterruptedException {
        Object object = this.sync;
        synchronized (object) {
            while (!this.done) {
                this.sync.wait();
            }
        }
        return this.result;
    }
}

