/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.net.ppp.DialupTask;
import fxterm.core.timer.Timer;
import org.apache.log4j.Logger;
import ru.softlogic.reference.References;

public class UssdCheckTaskGenerator
implements Runnable {
    private final DialupSystem dialupSystem;
    private final DialupTask dialupTask;
    private final Logger log = LoggerId.DIALUP;
    private long lastTime;

    public UssdCheckTaskGenerator(DialupSystem dialupSystem, DialupTask dialupTask) {
        this.dialupSystem = dialupSystem;
        this.dialupTask = dialupTask;
    }

    @Override
    public void run() {
        long currTime = Timer.currentMin();
        if (this.lastTime == 0L || currTime - this.lastTime > this.getRequestTimeout()) {
            this.log.info((Object)"Needs to check balance");
            this.lastTime = currTime;
            this.dialupSystem.addTask(this.dialupTask);
        }
    }

    private long getRequestTimeout() {
        int balanceTimeout = 4;
        if (References.getPointOptions() != null) {
            balanceTimeout = References.getPointOptions().getBalanceTimeout();
        }
        if (balanceTimeout < 6) {
            balanceTimeout = 6;
        }
        if (balanceTimeout > 168) {
            balanceTimeout = 168;
        }
        return (long)balanceTimeout * 60L;
    }
}

