/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.CompatDeviceInfoListener;
import fxterm.core.net.ppp.DialupTask;
import fxterm.session.Session;
import java.io.IOException;
import java.util.Date;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemInfo;
import ru.softlogic.hdw.dev.modem.NetworkInfo;
import ru.softlogic.hdw.dev.modem.NotRegisteredException;
import ru.softlogic.hdw.dev.modem.OpenException;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.modem.Operator;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.connector.ClientInterface;

public class UssdCheckTask
extends CompatDeviceInfoListener
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;
    private DeviceInfo lastDeviceInfo;
    private static final int SLEEP_TIMEOUT = 1000;
    private static final int ATTEMPT_COUNT = 20;
    private static final int ATTEMPT_PAUSE = 500;
    private boolean updated = false;

    public UssdCheckTask(ClientInterface client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        this.log.info((Object)"Check balance");
        boolean needConnect = false;
        int state = conn.getState();
        this.log.info((Object)("Connection state: " + conn.getStateAsStr(state)));
        if (conn.getState() != 1) {
            this.log.info((Object)"Disconnect dialup");
            conn.disconnect();
            needConnect = true;
            Thread.sleep(1000L);
        }
        try {
            for (int i = 0; i < 20; ++i) {
                try {
                    this.log.info((Object)("Try to open device. Attempt " + i));
                    modem.open();
                    this.log.info((Object)"Done, init modem");
                    ModemInfo mi = modem.init();
                    DeviceInfo current = mi.getDeviceInfo();
                    this.log.info((Object)("Info: " + current));
                    if (this.lastDeviceInfo == null || !this.lastDeviceInfo.equals((Object)current)) {
                        this.log.info((Object)"Send device info to server");
                        this.lastDeviceInfo = current;
                        this.onDeviceInfo(current);
                    }
                    NetworkInfo ni = modem.getNetworkInfo();
                    this.log.info((Object)("Network info: " + ni));
                    ModemState ms = new ModemState(ni.getBalance(), ni.getSignal(), new Operator(ni.getMncmcc(), ni.getName()), ni.getLac(), ni.getCid());
                    ms.setImei(mi.getImei());
                    ms.setImsi(mi.getImsi());
                    this.client.sendModemState(ms);
                    this.setInSessionDeviceState(conn.getStateAsStr(state), current, ni);
                    break;
                }
                catch (OpenException ex) {
                    this.log.error((Object)"Error on open modem port", (Throwable)ex);
                    Thread.sleep(500L);
                    continue;
                }
            }
        }
        catch (IOException ex) {
            this.log.error((Object)"Io error", (Throwable)ex);
        }
        catch (NotRegisteredException ex) {
            this.log.error((Object)ex.getMessage());
        }
        finally {
            this.log.info((Object)"Try to close modem");
            modem.close();
            this.log.info((Object)"Close done");
        }
        if (needConnect) {
            this.log.info((Object)"Start dialup connection");
            conn.connect();
        }
        this.log.info((Object)"Done");
    }

    @Override
    protected void afterSend(DeviceInfo info) {
        if (!this.updated) {
            this.client.sendStatus(new DeviceStatus(Short.valueOf((short)6), 0));
            this.updated = true;
        }
    }

    private void setInSessionDeviceState(String state, DeviceInfo info, NetworkInfo ni) {
        Session.setDefaultItem("modem_state", state);
        Session.setDefaultItem("modem_network", ni);
        Session.setDefaultItem("modem_info", info);
        Session.setDefaultItem("modem_last_check", new Date());
    }
}

