/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupTask;
import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.NotRegisteredException;
import ru.softlogic.hdw.dev.modem.OpenException;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;
import ru.softlogic.system.util.network.Ping;

class RestoreNetworkTask
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;

    RestoreNetworkTask() {
    }

    @Override
    public final void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        this.log.info((Object)"Check dialup-connection state");
        this.log.info((Object)("    Modem exist: " + (modem != null)));
        this.log.info((Object)("    WatchDog exist: " + (watchDog != null)));
        this.log.info((Object)("    Ping result: " + (Ping.isNetworkAlive() ? "network alive" : "network error")));
        boolean stopped = this.stopConn(conn);
        if (!stopped) {
            this.log.error((Object)"Error on stop connection");
            return;
        }
        this.log.info((Object)"Connection stopped");
        Thread.sleep(4000L);
        this.checkLink(modem);
        this.resetModem(modem);
        this.resetWdt(watchDog);
        Thread.sleep(7500L);
        this.log.info((Object)"Start connection");
        conn.connect();
        this.log.info((Object)"Task done");
    }

    private boolean stopConn(Connection conn) {
        for (int i = 0; i < 5; ++i) {
            try {
                if (conn.getState() == 1) {
                    return true;
                }
                this.log.info((Object)"Try to stop connection");
                conn.disconnect();
                continue;
            }
            catch (DialupException | RPCException ex) {
                this.log.error((Object)"Error on stop connection", ex);
            }
        }
        return false;
    }

    private void resetWdt(WatchDog watchDog) {
        if (watchDog != null) {
            this.log.info((Object)"WatchDog is present, reset modem");
            watchDog.resetModem();
        } else {
            this.log.info((Object)"WatchDog is not found, can't reboot modem");
        }
    }

    private void resetModem(Modem modem) {
        if (modem != null && modem.getSoftwareWatchdog() != null) {
            this.log.info((Object)"Modem with power module is present, reset modem");
            try {
                modem.open();
                modem.getSoftwareWatchdog().resetModem();
                this.log.info((Object)"Success");
            }
            catch (IOException | OpenException ex) {
                this.log.error((Object)"Error on reset modem", ex);
            }
            finally {
                modem.close();
            }
        } else {
            this.log.info((Object)"Modem or modem wdt interface is not found, can't reboot modem");
        }
    }

    private void checkLink(Modem modem) {
        if (modem == null) {
            return;
        }
        try {
            this.log.info((Object)"Get signal level");
            modem.open();
            int level = modem.getSignalLevel();
            this.log.info((Object)("    result: " + level));
        }
        catch (IOException | OpenException ex) {
            this.log.error((Object)"I/O error", ex);
        }
        catch (NotRegisteredException ex) {
            this.log.error((Object)"Modem is not registered in gsm network");
        }
        finally {
            modem.close();
        }
    }
}

