/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupTask;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;
import ru.softlogic.system.util.network.Ping;

class PppRestartTask
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;
    private final boolean forceDisconnect;

    public PppRestartTask(boolean forceDisconnect) {
        this.forceDisconnect = forceDisconnect;
    }

    @Override
    public void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        int state = conn.getState();
        this.log.info((Object)("Connection state: " + conn.getStateAsStr(state)));
        if (state == 0) {
            if (this.forceDisconnect) {
                this.log.info((Object)"Force disconnect");
                conn.disconnect();
                Thread.sleep(4000L);
                this.log.info((Object)"Connect");
                conn.connect();
            } else {
                this.log.info((Object)("Ping result: " + (Ping.isNetworkAlive() ? "network alive" : "network error")));
            }
        } else if (state == 1) {
            this.log.info((Object)"Connect");
            conn.connect();
            this.log.info((Object)"Success");
        }
    }
}

