/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.net.ppp.DialupTask;
import fxterm.core.net.ppp.PppRestartTask;
import fxterm.core.net.ppp.RestoreNetworkTask;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.timer.Timer;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.NetObserver;

public class NetworkObserver2
implements NetObserver {
    private DialupSystem dialupSystem;
    private final Logger log = LoggerId.DIALUP;
    private int errCount = -1;
    private long lastTry;
    private long lastConn;

    public NetworkObserver2(DialupSystem dialupSystem) {
        if (dialupSystem == null) {
            throw new NullPointerException("DialupSystem is null");
        }
        this.dialupSystem = dialupSystem;
    }

    public void update(boolean netError) {
        this.log.info((Object)("Conn error: " + netError));
        if (!netError) {
            this.lastConn = Timer.currentSec();
        }
        int n = this.errCount = netError ? this.errCount + 1 : 0;
        if (this.errCount == 1) {
            this.log.info((Object)"Check state");
            this.dialupSystem.addTask(new PppRestartTask(false));
        } else if (this.errCount == 3) {
            this.log.info((Object)"Try to connect/disconnect");
            this.makeAction(new PppRestartTask(true));
        } else if (this.errCount >= 6) {
            if (Timer.currentSec() - this.lastConn > 1800L) {
                this.log.info((Object)"Is too long no connection, restart terminal");
                SafeReboot.reboot(9);
            }
            if (this.errCount % 5 == 0) {
                this.log.info((Object)"Try to restore");
                this.makeAction(new RestoreNetworkTask());
            }
        }
    }

    private void makeAction(DialupTask task) {
        if (Timer.currentSec() - this.lastTry > 90L) {
            this.log.info((Object)"Process request");
            this.lastTry = Timer.currentSec();
            this.dialupSystem.addTask(task);
        } else {
            this.log.info((Object)"Timeout detected, request rejected");
        }
    }
}

