/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.modem.BaseModemJob;
import fxterm.core.net.ppp.DialupTask;
import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

public class ModemTask
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;
    private static final int SLEEP_TIMEOUT = 1000;
    private final BaseModemJob smsJob;

    public ModemTask(BaseModemJob smsJob) {
        this.smsJob = Objects.requireNonNull(smsJob, "Job is null");
    }

    @Override
    public void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        boolean needConnect = this.disconnect(conn);
        this.smsJob.execute(modem);
        this.connect(conn, needConnect);
        this.log.info((Object)"Done");
    }

    private boolean disconnect(Connection conn) throws RPCException, DialupException, InterruptedException {
        if (conn.getState() != 1) {
            this.log.info((Object)"Disconnect dialup");
            conn.disconnect();
            Thread.sleep(1000L);
            return true;
        }
        return false;
    }

    private void connect(Connection conn, boolean needConnect) throws RPCException, DialupException {
        if (needConnect) {
            this.log.info((Object)"Start dialup connection");
            conn.connect();
        }
    }
}

