/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.CheckStateTask;
import fxterm.core.net.ppp.ConnectionProxy;
import fxterm.core.net.ppp.DialupSystemListener;
import fxterm.core.net.ppp.DialupTask;
import fxterm.core.reboot.SafeReboot;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.BaseConnection;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

public class DialupSystem
implements Runnable {
    private final Connection conn;
    private final WatchDog watchDog;
    private final Modem modem;
    private final CheckStateTask checkStateTask;
    private final Logger log = LoggerId.DIALUP;
    private final BlockingQueue<DialupTask> tasks = new LinkedBlockingQueue<DialupTask>();
    private final Set<DialupSystemListener> listeners = new HashSet<DialupSystemListener>();
    private int rpcError;
    private int dialupError;

    public DialupSystem(ConnectionManager manager, String connName, WatchDog watchDog, Modem modem) {
        if (manager == null) {
            throw new NullPointerException("ConnectionManager is null");
        }
        if (connName == null || connName.isEmpty()) {
            throw new NullPointerException("Connection name is null or empty");
        }
        this.watchDog = watchDog;
        this.modem = modem;
        this.conn = new ConnectionProxy((Connection)new BaseConnection(connName, manager), this.listeners);
        this.checkStateTask = new CheckStateTask();
    }

    public void addListener(DialupSystemListener listener) {
        this.check(listener);
        this.listeners.add(listener);
    }

    public void removeListener(DialupSystemListener listener) {
        this.check(listener);
        this.listeners.remove(listener);
    }

    public void addTask(DialupTask task) {
        if (task == null) {
            throw new NullPointerException("Task is null");
        }
        this.tasks.add(task);
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                DialupTask dt = this.tasks.poll(10L, TimeUnit.SECONDS);
                try {
                    if (dt != null) {
                        dt.process(this.conn, this.watchDog, this.modem);
                    } else {
                        this.checkStateTask.process(this.conn, this.watchDog, this.modem);
                    }
                    this.dialupError = 0;
                    this.rpcError = 0;
                }
                catch (DialupException ex) {
                    this.log.error((Object)"Error on dialup", (Throwable)ex);
                    ++this.dialupError;
                }
                catch (RPCException ex) {
                    this.log.error((Object)"RPC error on dialup", (Throwable)ex);
                    ++this.rpcError;
                }
                if (this.rpcError <= 2) continue;
                this.log.info((Object)"Too many rpc errors, reboot terminal");
                SafeReboot.reboot(8);
                break;
            }
        }
        catch (InterruptedException ex) {
            this.log.info((Object)"Interrupted");
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }

    private void check(DialupSystemListener listener) {
        if (listener == null) {
            throw new NullPointerException("DialupSystemListener is null");
        }
    }

    public boolean hasModem() {
        return this.modem != null;
    }

    public boolean hasWatchDog() {
        return this.watchDog != null;
    }
}

