/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.core.net.ppp.DialupSystemListener;
import java.util.Set;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

class ConnectionProxy
implements Connection {
    private Connection conn;
    private Set<DialupSystemListener> listeners;

    public ConnectionProxy(Connection conn, Set<DialupSystemListener> listeners) {
        if (conn == null) {
            throw new NullPointerException("Connection is null");
        }
        if (listeners == null) {
            throw new NullPointerException("Listeners is null");
        }
        this.conn = conn;
        this.listeners = listeners;
    }

    public String getName() {
        return this.conn.getName();
    }

    public void connect() throws RPCException, DialupException {
        try {
            this.conn.connect();
            this.notifyConnect();
        }
        catch (DialupException | RPCException ex) {
            this.notifyException((Exception)ex);
            throw ex;
        }
    }

    public void disconnect() throws RPCException, DialupException {
        try {
            this.conn.disconnect();
            this.notifyDisconnect();
        }
        catch (DialupException | RPCException ex) {
            this.notifyException((Exception)ex);
            throw ex;
        }
    }

    public int getState() throws RPCException, DialupException {
        return this.conn.getState();
    }

    public String getStateAsStr(int i) {
        return this.conn.getStateAsStr(i);
    }

    private void notifyConnect() {
        for (DialupSystemListener dsl : this.listeners) {
            dsl.afterConnect();
        }
    }

    private void notifyDisconnect() {
        for (DialupSystemListener dsl : this.listeners) {
            dsl.afterDisconnect();
        }
    }

    private void notifyException(Exception ex) {
        for (DialupSystemListener dsl : this.listeners) {
            dsl.onError(ex);
        }
    }
}

