/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net.ppp;

import fxterm.app.id.LoggerId;
import fxterm.core.net.ppp.DialupTask;
import fxterm.session.Session;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

class CheckStateTask
implements DialupTask {
    private final Logger log = LoggerId.DIALUP;
    private int lastState = -1;

    CheckStateTask() {
    }

    @Override
    public void process(Connection conn, WatchDog watchDog, Modem modem) throws DialupException, RPCException, InterruptedException {
        int state = conn.getState();
        if (state != this.lastState) {
            this.log.info((Object)("Dialup state changed: " + conn.getStateAsStr(this.lastState) + "->" + conn.getStateAsStr(state)));
            this.lastState = state;
        }
        if (state == 1) {
            this.log.error((Object)"Dialup disconnect, try to connect");
            conn.connect();
            this.log.error((Object)"Success");
        }
        this.setInSessionDeviceState(conn.getStateAsStr(state));
    }

    private void setInSessionDeviceState(String state) {
        Session.setDefaultItem("modem_state", state);
    }
}

