/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net;

import fxterm.app.id.LoggerId;
import fxterm.core.net.QueueAgent;
import fxterm.core.net.ppp.DialupSystemListener;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class QueueAgentNotifier
implements DialupSystemListener {
    private final ScheduledExecutorService service;
    private final QueueAgent agent;
    private final Logger log = LoggerId.NETWORK;

    public QueueAgentNotifier(ScheduledExecutorService service, QueueAgent agent) {
        if (service == null) {
            throw new NullPointerException("ScheduledExecutorService is null");
        }
        if (agent == null) {
            throw new NullPointerException("QueueAgent is null");
        }
        this.service = service;
        this.agent = agent;
    }

    @Override
    public void afterConnect() {
        this.log.info((Object)"Schedule agent notify");
        this.service.schedule(new WakeUper(), 5L, TimeUnit.SECONDS);
    }

    @Override
    public void afterDisconnect() {
    }

    @Override
    public void onError(Exception ex) {
    }

    private class WakeUper
    implements Runnable {
        private WakeUper() {
        }

        @Override
        public void run() {
            QueueAgentNotifier.this.log.info((Object)"Make agent notify");
            QueueAgentNotifier.this.agent.wakeup();
        }
    }
}

