/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net;

import fxterm.app.id.LoggerId;
import fxterm.core.menu.MenuUpdater;
import fxterm.core.menu.MenuUtils;
import fxterm.core.net.HotKeyVisitor;
import fxterm.core.net.TooManyRejectExcetion;
import fxterm.core.reboot.SafeReboot;
import fxterm.core.timer.Timer;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.ReferenceData;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.References;
import ru.softlogic.reference.ReferencesIO;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.exchange.ExchangeProfile;
import ru.softlogic.reference.hdw.DispenseProfile;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.weather.Weather;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.MoneyCollection;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.refs.SrvReferences;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.cash.Statistics;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.RefVersionObserver;
import ru.softlogic.srv.connector.RemoteStatusObserver;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.CashTransfer;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.srv.queue.Queue;
import ru.softlogic.storage.io.SetDataStore;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.os.OsApi;

public class QueueAgent
implements Runnable,
RemoteStatusObserver,
RefVersionObserver {
    private static final int REFS_TIMEOUT = 3;
    private static final int DEFAULT_REFS_MAX_TIMEOUT = 20;
    private static final int REFS_MAX_TIMEOUT_NIGHT = 60;
    private int refsMaxTimeOut;
    private final Logger log = LoggerId.NETWORK;
    private Queue queue;
    private SetDataStore<Command> commandStore;
    private ServerInterface serverInterface;
    private long lastRefsRequest;
    private long lastConnect;
    private int remoteStatus;
    private long remoteRefVersion = 0L;
    private boolean syncTime;
    private int maxPackageSize = 3;
    private int timeout = 10;
    private int errCount;
    private int currReject;
    private int lastReject;

    public QueueAgent(Queue queue, SetDataStore<Command> commandStore, ServerInterface serverInterface) {
        if (queue == null) {
            throw new IllegalArgumentException("Queue is null");
        }
        if (commandStore == null) {
            throw new IllegalArgumentException("CommandStore is null");
        }
        if (serverInterface == null) {
            throw new IllegalArgumentException("ServerInterface is null");
        }
        this.queue = queue;
        this.commandStore = commandStore;
        this.serverInterface = serverInterface;
        this.lastConnect = Timer.currentSec();
    }

    public void update(int remoteStatus) {
        this.remoteStatus = remoteStatus;
        this.lastConnect = Timer.currentSec();
        this.log.debug((Object)("Get new remote state: " + remoteStatus));
    }

    public void update(long version) {
        this.log.debug((Object)("New references version: " + version));
        this.remoteRefVersion = version;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Local references version: " + References.getVersion()));
        boolean needPing = false;
        try {
            this.sleep(15);
            while (!Thread.currentThread().isInterrupted()) {
                PointOptions po = References.getPointOptions();
                if (po != null) {
                    this.timeout = References.getPointOptions().getQueueScanTimeout();
                    this.maxPackageSize = References.getPointOptions().getMaxPackageSize();
                    this.refsMaxTimeOut = References.getPointOptions().getConnectTimeout();
                }
                try {
                    this.sync();
                    if (needPing) {
                        this.log.info((Object)"Try to ping");
                        try {
                            this.serverInterface.ping();
                        }
                        catch (ConnectorException ex) {
                            this.log.error((Object)"Erron on ping request", (Throwable)ex);
                        }
                    }
                    if ((this.remoteStatus & 1) != 0) {
                        if ((this.remoteStatus & 8) == 0) {
                            this.log.info((Object)"Point is blocked. Requests forbidden");
                            this.sleep(420);
                            try {
                                this.serverInterface.ping();
                            }
                            catch (ConnectorException ex) {
                                this.log.error((Object)"Erron on ping request", (Throwable)ex);
                            }
                        } else {
                            this.log.info((Object)"Point is blocked. Requests allowed");
                            this.getRefs();
                            this.sendPackets();
                        }
                    } else {
                        this.getRefs();
                        this.sendPackets();
                    }
                    this.sleep(this.timeout <= 0 ? 10 : this.timeout, false);
                    needPing = false;
                    this.errCount = 0;
                }
                catch (TooManyRejectExcetion ex) {
                    this.log.info((Object)"Too many rejects", (Throwable)ex);
                    this.lastReject += this.currReject;
                    this.sleep(120, true);
                }
                catch (InterruptedException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    ++this.errCount;
                    needPing = true;
                    this.log.error((Object)ex, ex);
                    if (this.errCount % 5 == 0) {
                        this.log.info((Object)"Sleep 45 seconds");
                        this.sleep(45);
                        continue;
                    }
                    this.log.info((Object)"Sleep 5 seconds");
                    this.sleep(5);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.log.info((Object)"Interrupted");
        }
        this.queue.close();
        this.log.info((Object)"Stop thread");
    }

    private void getRefs() throws InterruptedException, ConnectorException {
        if (this.lastRefsRequest == 0L || Timer.currentSec() - this.lastRefsRequest > 180L) {
            boolean flag = false;
            if (References.getVersion() != this.remoteRefVersion && this.remoteRefVersion > 0L || References.getVersion() == 0L) {
                this.log.info((Object)("Change references version: local=" + References.getVersion() + " remote=" + this.remoteRefVersion));
                flag = true;
            } else if (Timer.currentSec() - this.lastConnect > (long)this.calcTimeout(References.getPointOptions().isUseNightMode()) * 60L) {
                this.log.info((Object)("Do not connect to the server over " + this.calcTimeout(References.getPointOptions().isUseNightMode()) + " min"));
                flag = true;
            }
            if (!flag) {
                return;
            }
            SrvReferences references = this.serverInterface.getReferences();
            this.log.info((Object)("References: " + references));
            if (references != null) {
                if (References.getVersion() != references.getVersion()) {
                    if (references.getDealer() != null) {
                        LocalReferences.getData().setDealer(references.getDealer());
                        this.log.info((Object)("Get new dealer info: " + references.getDealer()));
                    }
                    if (references.getMenuItemStates() != null) {
                        MenuItemState[] miss = references.getMenuItemStates();
                        TreeMap<Short, MenuItemState> mism = new TreeMap<Short, MenuItemState>();
                        for (MenuItemState mis : miss) {
                            mism.put(mis.getServiceId(), mis);
                        }
                        LocalReferences.getData().setMenuItemStates(mism);
                        this.log.info((Object)"Get new menu states info");
                    }
                    boolean needRebuildHot = false;
                    if (references.getMenu() != null) {
                        LocalReferences.getData().setMenu(references.getMenu());
                        this.log.info((Object)("Get new menu: " + references.getMenu()));
                        needRebuildHot = true;
                    }
                    if (references.getChanged() != null && references.getChanged().length > 0) {
                        this.log.info((Object)("Some menu items is changed: " + Arrays.toString(references.getChanged())));
                        MenuUtils.processMenu(new MenuUpdater(references.getChanged()));
                        needRebuildHot = true;
                    }
                    if (needRebuildHot) {
                        this.log.info((Object)"Rebuild hot buttons");
                        HotKeyVisitor hkv = new HotKeyVisitor();
                        MenuUtils.processMenu(hkv);
                        LocalReferences.getData().setHotItems(hkv.getMenuItems());
                        LocalReferences.getData().setHotGroups(hkv.getServiceTypes());
                        this.log.info((Object)"Rebuild done");
                    }
                    if (references.getPoint() != null) {
                        LocalReferences.getData().setPoint(references.getPoint());
                        this.log.info((Object)("Get new point info: " + references.getPoint()));
                    }
                    if (references.getPointOptions() != null) {
                        LocalReferences.getData().setPointOptions(references.getPointOptions());
                        this.log.info((Object)"Get new point params");
                    }
                    if (references.getServiceOptions() != null) {
                        LocalReferences.getData().setServiceOptions(references.getServiceOptions());
                        this.log.info((Object)"\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u043e\u043f\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0435\u0434\u0437\u0430\u043a\u0443\u043f\u043a\u0435 \u043a\u0430\u0440\u0442");
                    }
                    if (references.getPersonalNumbers() != null) {
                        LocalReferences.getData().setPersonalNumbers(references.getPersonalNumbers());
                        this.log.info((Object)"Get new personal numbers");
                    }
                    if (references.getBanners() != null) {
                        LocalReferences.getData().setBanners(references.getBanners());
                        this.log.info((Object)("Get new banners info: " + Arrays.toString(references.getBanners())));
                    }
                    if (references.getMovies() != null) {
                        LocalReferences.getData().setMovies(references.getMovies());
                        this.log.info((Object)("Get new movies info: " + Arrays.toString(references.getMovies())));
                    }
                    if (references.getCheckAdvs() != null) {
                        LocalReferences.getData().setCheckAdvs(references.getCheckAdvs());
                        this.log.info((Object)("Get new doc adv: " + Arrays.toString(references.getCheckAdvs())));
                    }
                    if (references.getAuth() != null) {
                        LocalReferences.getData().setAuth(references.getAuth());
                        this.log.info((Object)"Get new mail server info");
                    }
                    if (references.getUpdateOptions() != null) {
                        LocalReferences.getData().setUpdateOptions(references.getUpdateOptions());
                        this.log.info((Object)"Get new update system info");
                    }
                    if (references.getCommands() != null) {
                        this.commandStore.add((Object[])references.getCommands());
                    }
                    if (references.getPaymentSystem() != null) {
                        LocalReferences.getData().setPaymentSystem(references.getPaymentSystem());
                        this.log.info((Object)"Get new payment system info");
                    }
                    if (references.getBank() != null) {
                        LocalReferences.getData().setBank(references.getBank());
                        this.log.info((Object)"Get new bank info");
                    }
                    if (references.getServerAddresses() != null) {
                        LocalReferences.getData().setServerAddresses(references.getServerAddresses());
                        this.log.info((Object)"Get new processing hosts info");
                    }
                    if (references.getServerUsers() != null) {
                        LocalReferences.getData().setServerUsers(references.getServerUsers());
                        this.log.info((Object)"Get new users data");
                    }
                    if (references.getPromos() != null) {
                        LocalReferences.getData().setPromos(references.getPromos());
                        this.log.info((Object)"Get new promo info");
                    }
                    if (references.getBonuses() != null) {
                        LocalReferences.getData().setBonuses(references.getBonuses());
                        this.log.info((Object)"Get new bonus info");
                    }
                    if (references.getCurrencyRates() != null) {
                        this.log.info((Object)"Update currency rates");
                        LocalReferences.getData().setCurrencyRates(references.getCurrencyRates());
                    }
                    if (references.getExchangeProfile() != null) {
                        this.log.info((Object)"Update exchange profile");
                        LocalReferences.setExchangeProfile((ExchangeProfile)references.getExchangeProfile());
                    }
                    if (references.getDispenseProfile() != null) {
                        this.log.info((Object)"Update Dispense Profile");
                        LocalReferences.setDispenseProfile((DispenseProfile)references.getDispenseProfile());
                    }
                    if (references.getWeather() != null) {
                        this.log.info((Object)"Update weather");
                        LocalReferences.setWeathers((Weather[])references.getWeather());
                    }
                    if (references.getFraudControlRules() != null) {
                        LocalReferences.setFraudControlRules((List)references.getFraudControlRules());
                        this.log.info((Object)"Update fraud control rules");
                    }
                    if (references.getGeographicAreas() != null) {
                        LocalReferences.setGeographicAreas((List)references.getGeographicAreas());
                        this.log.info((Object)"Update geographic areas");
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        this.log.info((Object)("New references version: " + references.getVersion()));
                        References.setVersion((long)references.getVersion());
                        References.setSoftware((String)DaemonVersion.version);
                        try {
                            this.log.info((Object)"Try to save references");
                            ReferencesIO.save((File)PathUtils.getFilePath((String)"/data/references.pst"));
                            this.log.info((Object)"Done!");
                        }
                        catch (ReferenceException ex) {
                            this.log.error((Object)"Error on save references", (Throwable)ex);
                        }
                    } else {
                        this.log.warn((Object)"Thread is interrupted, don't save references");
                    }
                } else {
                    this.log.info((Object)"References version is not change");
                }
            }
            this.lastRefsRequest = Timer.currentSec();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendPackets() throws InterruptedException, TooManyRejectExcetion {
        this.currReject = 0;
        try {
            AdvStatistic[] advStats;
            Object[] boxStatuses;
            Object[] boxAmounts;
            Object[] boxInfos;
            Object[] demands;
            Object[] updateStates;
            CbcStatus[] csrs;
            NetworkStatistics[] nses;
            JammInfo[] jammInfos;
            List list;
            CommandResult[] commandResults;
            NetworkDevice[] devices;
            ModemState state;
            SaleConfirm[] confirms;
            Statistics[] stats;
            MoneyCollection[] moneyCollections;
            GroupOperation[] groupOperations;
            long now;
            Operation[] operations;
            DeviceStatus[] statuses;
            DeviceInfoStub[] infos;
            Event[] events;
            EnvRiskFactors erf;
            SystemInfo si = this.queue.getSystemInfo();
            if (si != null) {
                this.log.info((Object)"Send SystemInfo");
                if (this.checkResult(this.serverInterface.sendSystemInfo(new SystemInfo[]{si}))) {
                    this.queue.setSystemInfo(null);
                }
            }
            if ((erf = this.queue.getEvnRiskFactors()) != null) {
                this.log.info((Object)"Send ERF");
                if (this.checkResult(this.serverInterface.sendEnvRiskFactors(erf))) {
                    this.queue.setEvnRiskFactors(null);
                }
            }
            if ((events = this.queue.getEvents()) != null && events.length > 0) {
                this.log.info((Object)("Total events: " + events.length));
                if (this.checkResult(this.serverInterface.sendEvents(events))) {
                    this.queue.deleteEvents(events);
                }
            }
            if ((infos = this.queue.getDeviceInfo()) != null && infos.length > 0) {
                this.log.info((Object)("Total device infos: " + infos.length));
                if (this.checkResult(this.serverInterface.sendDeviceInfo(infos))) {
                    this.queue.deleteDeviceInfos(infos);
                }
            }
            if ((statuses = this.queue.getDeviceStatuses()) != null && statuses.length > 0) {
                this.log.info((Object)("Total device states: " + statuses.length));
                if (this.checkResult(this.serverInterface.sendStatuses(statuses))) {
                    this.queue.deleteDeviceStatuses(statuses);
                }
            }
            if ((operations = this.queue.getOperations()) != null && operations.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + operations.length + " \u0444\u0438\u043b\u044c\u0442\u0440\u0443\u044e \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0435"));
                LinkedList<Operation> fl = new LinkedList<Operation>();
                now = Timer.currentSec();
                for (Operation op : operations) {
                    void var14_21;
                    Object var14_22 = null;
                    if (op.getFraudControlRule() != null) {
                        Integer n = op.getFraudControlRule().getSendTimeout();
                    }
                    if (var14_21 != null) {
                        this.log.info((Object)("" + op.getService().getName() + ":" + op.getTime() + ": " + now + " <=" + (op.getTime() + (long)var14_21.intValue())));
                    }
                    if ((op.getFlags() & 0x40) == 0 && var14_21 != null && op.getTime() > 0L && now <= op.getTime() + (long)var14_21.intValue()) continue;
                    this.log.info((Object)("List<Operation> 1: " + (op.getLastProcess() == 0L)));
                    this.log.info((Object)("List<Operation> 2: " + (now - op.getLastProcess() > 420L)));
                    this.log.info((Object)("List<Operation> 2: " + (op.getLastProcess() > now)));
                    if (op.getLastProcess() != 0L && now - op.getLastProcess() <= 420L && op.getLastProcess() <= now) continue;
                    fl.add(op);
                }
                if (!fl.isEmpty()) {
                    operations = fl.toArray(new Operation[fl.size()]);
                    if (this.maxPackageSize > 0 && operations.length > this.maxPackageSize) {
                        this.log.info((Object)("\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440 \u043f\u0430\u043a\u0435\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + this.maxPackageSize));
                        operations = Arrays.copyOf(operations, this.maxPackageSize);
                    }
                    Object[] states = this.serverInterface.processWithResult(operations);
                    this.log.info((Object)("Result: " + Arrays.toString(states)));
                    LinkedList<Operation> remOp = new LinkedList<Operation>();
                    now = Timer.currentSec();
                    for (int i = 0; i < states.length; ++i) {
                        Object os = states[i];
                        Operation operation = operations[i];
                        this.log.info((Object)("Op: " + operation + "->" + os));
                        if (os.getCheck() == operation.getCheckNumber() && os.getIdOperation() == operation.getIdOperation()) {
                            if (os.getError() == 0) {
                                this.log.info((Object)"Success state, remove");
                                remOp.add(operation);
                                continue;
                            }
                            if (os.getError() == 6) {
                                this.log.info((Object)"Error in cash units, remove");
                                remOp.add(operation);
                                continue;
                            }
                            this.log.info((Object)"Other error, operation will send later");
                            operation.setLastProcess(now);
                            continue;
                        }
                        this.log.error((Object)"Wrong result metrics");
                    }
                    if (!remOp.isEmpty()) {
                        this.log.info((Object)("Delete " + remOp.size() + " operations"));
                        this.queue.deleteOperations(remOp.toArray(new Operation[remOp.size()]));
                    } else {
                        this.log.info((Object)"Nothing to delete");
                    }
                }
            }
            if ((groupOperations = this.queue.getGroupOperations()) != null && groupOperations.length > 0) {
                this.log.info((Object)("\u0412\u0441\u0435\u0433\u043e \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + groupOperations.length));
                now = Timer.currentSec();
                LinkedList<GroupOperation> goList = new LinkedList<GroupOperation>();
                for (GroupOperation groupOperation : groupOperations) {
                    if ((groupOperation.getFlags() & 0x40) != 0) continue;
                    Integer delay = null;
                    if (groupOperation.getFraudControlRule() != null) {
                        delay = groupOperation.getFraudControlRule().getSendTimeout();
                    }
                    if (delay != null && groupOperation.getTime() > 0L && now <= groupOperation.getTime() + (long)delay.intValue()) continue;
                    goList.add(groupOperation);
                }
                if (!goList.isEmpty()) {
                    GroupOperation[] goArray = goList.toArray(new GroupOperation[goList.size()]);
                    if (this.serverInterface.processGroup(goArray)) {
                        this.log.info((Object)"\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u044b, \u0443\u0434\u0430\u043b\u044f\u044e \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438");
                        this.queue.deleteGroupOperations(goArray);
                    } else {
                        this.log.error((Object)"\u0421\u0435\u0440\u0432\u0435\u0440 \u043e\u0442\u043a\u0430\u0437\u0430\u043b \u0432 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0433\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0445 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439");
                    }
                }
            }
            if ((moneyCollections = this.queue.getMoneyCollections()) != null && moneyCollections.length > 0) {
                this.log.info((Object)("Total money collection: " + moneyCollections.length));
                if (this.checkResult(this.serverInterface.sendMoneyCollection(moneyCollections))) {
                    this.queue.deleteMoneyCollections(moneyCollections);
                }
            }
            if ((stats = this.queue.getStatistics()) != null && stats.length > 0) {
                this.log.info((Object)("Total statistics: " + stats.length));
                if (this.checkResult(this.serverInterface.sendStatistics(stats))) {
                    this.queue.deleteStatistics(stats);
                }
            }
            if ((confirms = this.queue.getSaleConfirms()) != null && confirms.length > 0) {
                this.log.info((Object)("Total sale confirms: " + confirms.length));
                if (this.checkResult(this.serverInterface.registerSales(confirms))) {
                    this.queue.deleteSaleConfirms(confirms);
                }
            }
            if ((state = this.queue.getModemState()) != null) {
                this.log.info((Object)("Modem state: " + state));
                if (this.checkResult(this.serverInterface.sendModemState(state))) {
                    this.queue.deleteModemState(state);
                }
            }
            if ((devices = this.queue.getNetworkDevices()) != null && devices.length > 0) {
                this.log.info((Object)"Send network interfaces info");
                if (this.checkResult(this.serverInterface.sendNetworkDevices(devices))) {
                    this.queue.deleteNetworkDevices(devices);
                }
            }
            if ((commandResults = this.queue.getCommandResults()) != null && commandResults.length > 0) {
                this.log.info((Object)"Send command results");
                for (CommandResult cr : commandResults) {
                    cr.setComment(cr.getComment() != null ? cr.getComment().replaceAll("\\p{C}", "?") : "");
                }
                if (this.checkResult(this.serverInterface.commandConfirm(commandResults))) {
                    this.queue.deleteCommandResults(commandResults);
                }
            }
            if (this.queue.getDiskSpace() != null) {
                this.log.info((Object)("Send disk space: " + this.queue.getDiskSpace() + " Mb"));
                if (this.checkResult(this.serverInterface.sendSpace(this.queue.getDiskSpace().intValue()))) {
                    this.queue.setDiskSpace(null);
                }
            }
            if ((list = this.queue.getCashTransfers()) != null && !list.isEmpty()) {
                this.log.info((Object)"Send cash transfers");
                if (this.checkResult(this.serverInterface.sendTransfers(list.toArray(new CashTransfer[list.size()])))) {
                    this.queue.deleteCashTransfers(list);
                }
            }
            if ((jammInfos = this.queue.getJamms()) != null && jammInfos.length > 0) {
                this.log.info((Object)"Send jamm infos");
                if (this.checkResult(this.serverInterface.sendJamm(jammInfos))) {
                    this.queue.deleteJamm(jammInfos);
                }
            }
            if ((nses = this.queue.getNetworkStatistics()) != null && nses.length > 0) {
                this.log.info((Object)"Send network statistics");
                if (this.checkResult(this.serverInterface.sendNetworkStatistics(nses))) {
                    this.queue.deleteNetworkStatistics(nses);
                }
            }
            if ((csrs = this.queue.getCbcStates()) != null && csrs.length > 0) {
                this.log.info((Object)"Send cbc states");
                if (this.checkResult(this.serverInterface.sendActivateStatus(csrs))) {
                    this.queue.deleteCbcStates(csrs);
                }
            }
            if ((updateStates = this.queue.getUpdateStates()) != null && updateStates.length > 0) {
                this.log.info((Object)("Send update state: " + Arrays.toString(updateStates)));
                for (Object status : updateStates) {
                    if (!this.checkResult(this.serverInterface.sendUpdateState((UpdateState)status))) continue;
                    this.queue.deleteUpdateState((UpdateState)status);
                }
            }
            if ((demands = this.queue.getDemands()) != null && demands.length > 0) {
                this.log.info((Object)("Send demands: " + Arrays.toString(demands)));
                if (this.checkResult(this.serverInterface.demand((Demand[])demands))) {
                    this.queue.deleteDemand((Demand[])demands);
                }
            }
            if ((boxInfos = this.queue.getBoxInfos()) != null && boxInfos.length > 0) {
                this.log.info((Object)("Send box info: " + Arrays.toString(boxInfos)));
                if (this.checkResult(this.serverInterface.sendBoxInfos((BoxInfo[])boxInfos))) {
                    this.queue.deleteBoxInfos((BoxInfo[])boxInfos);
                }
            }
            if ((boxAmounts = this.queue.getBoxAmounts()) != null && boxAmounts.length > 0) {
                this.log.info((Object)("Send box amount: " + Arrays.toString(boxAmounts)));
                if (this.checkResult(this.serverInterface.sendBoxAmounts((BoxAmount[])boxAmounts))) {
                    this.queue.deleteBoxAmounts((BoxAmount[])boxAmounts);
                }
            }
            if ((boxStatuses = this.queue.getBoxStatuses()) != null && boxStatuses.length > 0) {
                this.log.info((Object)("Send box states: " + Arrays.toString(boxStatuses)));
                if (this.checkResult(this.serverInterface.sendBoxStatuses((BoxStatus[])boxStatuses))) {
                    this.queue.deleteBoxStatuses((BoxStatus[])boxStatuses);
                }
            }
            if ((advStats = this.queue.getAdvStatistics()) != null && advStats.length > 0) {
                this.log.info((Object)"Send adv statistics");
                if (this.checkResult(this.serverInterface.sendAdvStatistics(advStats))) {
                    this.queue.deleteAdvStatistics(advStats);
                }
            }
        }
        catch (ConnectorException ex) {
            this.log.error((Object)"Erron on sending pack", (Throwable)ex);
            this.sleep(60);
        }
    }

    private void sleep(int sec) throws InterruptedException {
        this.sleep(sec, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(int sec, boolean writeLog) throws InterruptedException {
        if (writeLog) {
            this.log.info((Object)("Sleep, sec: " + sec));
        }
        QueueAgent queueAgent = this;
        synchronized (queueAgent) {
            this.wait((long)sec * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        QueueAgent queueAgent = this;
        synchronized (queueAgent) {
            this.notifyAll();
        }
    }

    private int calcTimeout(boolean useNightMode) {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        if (hour >= 7 && hour <= 22 || !useNightMode) {
            return this.refsMaxTimeOut > 0 && this.refsMaxTimeOut < 25 ? this.refsMaxTimeOut : 20;
        }
        return 60;
    }

    private void sync() {
        if (!this.syncTime) {
            this.log.info((Object)"Try to sync time");
            try {
                Date date = this.serverInterface.ping();
                this.syncTime = true;
                if (date != null) {
                    Date now = new Date();
                    this.log.info((Object)("Server time: " + date + ", point time: " + now));
                    if (Math.abs(now.getTime() - date.getTime()) > 90000L) {
                        this.log.info((Object)"Time difference more that 90 sec. Sync it");
                        int res = OsApi.getInstance().setLocalTime(date);
                        if (res == 0) {
                            this.log.info((Object)("Success, new time: " + new Date()));
                            if (Math.abs(now.getTime() - date.getTime()) > 1800000L) {
                                Date now2 = new Date();
                                if (Math.abs(now2.getTime() - now.getTime()) > 10000L) {
                                    this.log.info((Object)"Restart software");
                                    SafeReboot.exit(0, 6);
                                } else {
                                    this.log.error((Object)"Problem with timezones, nothing to do");
                                }
                            }
                        } else {
                            this.log.error((Object)("Error, local time: " + new Date() + ", error=" + res));
                        }
                    }
                } else {
                    this.log.info((Object)"Access denied");
                }
            }
            catch (ConnectorException ex) {
                this.log.error((Object)"Error on sync time", (Throwable)ex);
            }
            catch (Throwable ex) {
                this.log.error((Object)"Sync error", ex);
            }
        }
    }

    private boolean checkResult(boolean res) throws TooManyRejectExcetion {
        if (res) {
            this.log.info((Object)"Done, remove from queue");
            this.lastReject = 0;
            this.currReject = 0;
        } else {
            this.log.error((Object)"Request rejected");
            ++this.currReject;
            if (this.currReject >= 5 || this.lastReject >= 5 && this.currReject >= 2) {
                throw new TooManyRejectExcetion("Request rejected " + this.currReject + " times in a row. Total rejects " + this.lastReject);
            }
        }
        return res;
    }

    private static class LocalReferences
    extends References {
        private LocalReferences() {
        }

        public static ReferenceData getData() {
            return data;
        }
    }
}

