/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.net;

import fxterm.app.id.LoggerId;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.connector.ClientInterface;

public class NetworkInterfaceObserver
implements Runnable {
    private ClientInterface clientInterface;
    private Set<NetworkDevice> last;
    private final Logger log = LoggerId.APP;

    public NetworkInterfaceObserver(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new IllegalArgumentException("ClientInterface");
        }
        this.clientInterface = clientInterface;
    }

    @Override
    public void run() {
        try {
            Enumeration<NetworkInterface> ni = NetworkInterface.getNetworkInterfaces();
            HashSet<NetworkDevice> current = new HashSet<NetworkDevice>();
            if (ni != null) {
                while (ni.hasMoreElements()) {
                    NetworkInterface eth = ni.nextElement();
                    if (eth.isLoopback()) continue;
                    String name = eth.getName();
                    int mtu = eth.getMTU();
                    String hwd = null;
                    if (eth.getHardwareAddress() != null && eth.getHardwareAddress().length > 5) {
                        byte[] addr = eth.getHardwareAddress();
                        hwd = String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
                    }
                    Object ip = null;
                    Enumeration<InetAddress> addresses = eth.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress ia = addresses.nextElement();
                        if (ia == null) continue;
                        current.add(new NetworkDevice(name, ia.toString(), hwd, mtu));
                    }
                }
                if (!current.equals(this.last) && !current.isEmpty()) {
                    this.log.info((Object)("Network inerfaces was changed: " + current));
                    this.clientInterface.sendNetworkDevices(current.toArray(new NetworkDevice[current.size()]));
                    this.last = current;
                }
            }
        }
        catch (SocketException ex) {
            this.log.error((Object)"Error on read network adapters", (Throwable)ex);
        }
    }
}

