/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu.utils;

import fxterm.core.menu.MenuUtils;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.MenuItemFilter;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.ServiceTypeFilter;

public class Filters {
    public static final MenuItemFilter VOID_ITEM_FILTER = new VoidMenuItemFilter();
    public static final MenuItemFilter ACTIVE_ITEM_FILTER = new ActiveMenuItemFilter();
    public static final ServiceTypeFilter VOID_GROUP_FILTER = new VoidServiceTypeFilter();
    public static final ServiceTypeFilter ACTIVE_GROUP_FILTER = new ActiveServiceTypeFilter();

    private Filters() {
    }

    public static class ActiveServiceTypeFilter
    implements ServiceTypeFilter {
        public boolean accept(ServiceType st) {
            return !st.getName().startsWith("#") && !st.isHidden();
        }
    }

    public static class VoidServiceTypeFilter
    implements ServiceTypeFilter {
        public boolean accept(ServiceType st) {
            return true;
        }
    }

    public static class VoidMenuItemFilter
    implements MenuItemFilter {
        public boolean accept(MenuItem mi) {
            return true;
        }
    }

    public static class ActiveMenuItemFilter
    implements MenuItemFilter {
        public boolean accept(MenuItem mi) {
            MenuItemState mis = MenuUtils.getState(mi);
            return MenuUtils.currencySupport(mi.getService()) && !ButtonStatus.Hidden.equals((Object)mis.getButtonStatus()) && (!mi.isDisableOnSchedule() || !mi.isHideUnactive());
        }
    }
}

