/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu.utils;

import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.utils.Filters;
import fxterm.session.Session;
import fxterm.session.TextHelper;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import plfx.screen.menu.button.ActionListener;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.util.Locator;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.ServiceTypeLang;
import ru.softlogic.system.util.FileUtil;

public class ButtonInitFactory {
    private ButtonInitFactory() {
    }

    public static MenuButtonInit createButtonInit(MenuItem menuItem, ActionListener listener) {
        return ButtonInitFactory.createButtonInit(menuItem, MenuUtils.getState(menuItem), listener);
    }

    public static MenuButtonInit createButtonInit(MenuItem menuItem, MenuItemState mis, ActionListener listener) {
        String img = menuItem.getLogoAlt();
        URL url = Locator.getUrl((String)("/gui/skin/{name}/img/" + img), (boolean)false);
        if (url == null || !FileUtil.checkFileExists((String)url.getPath())) {
            img = menuItem.getService().getImage();
        }
        String logo = TextHelper.isEmpty(img) ? null : img;
        ButtonStatus btnStatus = mis.getButtonStatus();
        Service service = menuItem.getService();
        String comm = null;
        if (menuItem.hasFlag(8)) {
            comm = MenuUtils.getCommissionValue(menuItem.getCommission());
        }
        Map<String, String> tagPath = MenuUtils.getTagPaths(menuItem);
        HashMap<String, String> langs = new HashMap<String, String>();
        if (service.getLangs() != null) {
            for (String sl : service.getLangs().keySet()) {
                langs.put(sl, ((ServiceLang)service.getLangs().get(sl)).getName());
            }
        }
        langs.put("_", service.getName());
        boolean disable = !ButtonInitFactory.validateCurrency(menuItem) || menuItem.isDisableOnSchedule() && !menuItem.isHideUnactive() || btnStatus == ButtonStatus.Blocked;
        MenuButtonInit mi = new MenuButtonInit(null, service.getName(), langs, logo, service.getStyle(), null, disable, listener, tagPath, comm);
        return mi;
    }

    public static MenuButtonInit createButtonInit(ServiceType serviceType, String style, ActionListener actionListener) {
        String img = serviceType.getImage();
        boolean disable = Boolean.TRUE.equals(serviceType.getBlocked()) || serviceType.getNestedCount(Filters.ACTIVE_GROUP_FILTER, Filters.ACTIVE_ITEM_FILTER) == 0;
        MenuButtonInit mbi = new MenuButtonInit(null, serviceType.getName(), ButtonInitFactory.createI18nMap(serviceType), TextHelper.isEmpty(img) ? null : img, style == null || style.isEmpty() ? serviceType.getStyle() : style, null, disable, actionListener);
        return mbi;
    }

    public static Map<String, String> createI18nMap(ServiceType serviceType) {
        HashMap<String, String> langs = new HashMap<String, String>();
        if (serviceType.getLangs() != null) {
            for (String sl : serviceType.getLangs().keySet()) {
                langs.put(sl, ((ServiceTypeLang)serviceType.getLangs().get(sl)).getName());
            }
        }
        langs.put("_", serviceType.getName());
        return langs;
    }

    private static boolean validateCurrency(MenuItem menuItem) {
        NewKeeper2 keeper = Session.getPayEnv().getKeeper();
        String currency = keeper.getCurrency();
        if (!keeper.isEmpty() || keeper.getOut() != null && !keeper.getOut().isEmpty()) {
            String curr = menuItem.getService().getInCurrency();
            if (curr == null) {
                return false;
            }
            return curr.equals(currency);
        }
        return true;
    }
}

