/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu;

import fxterm.app.FxEnv;
import fxterm.app.SystemProp;
import fxterm.core.menu.GroupByMenuItemVisitor;
import fxterm.core.menu.MenuVisitor;
import fxterm.module.card.CardModuleHandler;
import fxterm.session.Session;
import fxterm.session.TemplateProcessor;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import plfx.GuiNotifier;
import plfx.util.Locator;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.system.util.FileUtil;

public class MenuUtils {
    public static MenuItemState getState(MenuItem menuItem) {
        if (menuItem == null || menuItem.getService() == null) {
            return MenuItemState.HIDDEN;
        }
        return MenuUtils.getState(menuItem.getService().getId());
    }

    public static MenuItemState getState(short serviceId) {
        Map map = References.getMenuItemStates();
        return map != null ? map.getOrDefault(serviceId, MenuItemState.DEFAULT) : MenuItemState.DEFAULT;
    }

    public static ServiceType getServiceType(MenuItem menuItem) {
        if (menuItem == null) {
            return null;
        }
        GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(menuItem);
        MenuUtils.processMenu(gbmiv);
        return gbmiv.getServiceType();
    }

    public static void processMenu(MenuVisitor mv) {
        Menu m = References.getMenu();
        if (m != null) {
            MenuUtils._processMenu(m.getTypes(), mv);
            if (mv.onEnd()) {
                MenuUtils._processMenu(m.getTypes(), mv);
            }
        }
    }

    private static boolean _processMenu(ServiceType[] types, MenuVisitor mv) {
        if (types == null || types.length == 0) {
            return true;
        }
        for (ServiceType st : types) {
            if (!mv.processGroup(st)) continue;
            if (!mv.onGroup(st)) {
                return false;
            }
            if (st.getMenuItems() != null) {
                for (MenuItem menuItem : st.getMenuItems()) {
                    if (SystemProp.isRemoveIncorrectService() && !MenuUtils.currencySupport(menuItem.getService()) || mv.onMenuItem(menuItem)) continue;
                    return false;
                }
            }
            if (MenuUtils._processMenu(st.getTypes(), mv)) continue;
            return false;
        }
        return true;
    }

    public static boolean currencySupport(Service service) {
        String inCurrency = service.getInCurrency();
        int schemaFlags = service.getPaymentSchemaFlags();
        boolean isCardSource = (schemaFlags & 4) != 0;
        CardModuleHandler cardHandler = FxEnv.getCardModuleHandler();
        boolean isCMReady = cardHandler != null && cardHandler.isInit() && cardHandler.isReady();
        return isCardSource && isCMReady || FxEnv.getCashManager().currencySupport(inCurrency);
    }

    public static String getCommissionValue(Commission c) {
        return MenuUtils.getCommissionValue(c, "tag_simple{0}.vm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCommissionValue(Commission c, String simpleTplPath) {
        if (c == null) {
            return null;
        }
        Locale loc = Session.getLocale();
        Map<String, Object> data = Session.getData();
        data.put("commission", c);
        InputStream simple = Locator.getInputStream((String)("/gui/skin/{name}/i18n/comm//" + simpleTplPath), (Locale)loc);
        if (simple == null) {
            simple = Locator.getInputStream((String)("/plfx/i18n/comm/" + simpleTplPath), (Locale)loc);
        }
        try {
            String string = TemplateProcessor.processText(IOUtils.toString((InputStream)simple, (String)"UTF-8"), data, simpleTplPath);
            return string;
        }
        catch (Exception ex) {
            GuiNotifier.notifyProblemOnce((String)("Commission template tag_simple.vm not found, " + ex.getMessage()));
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)simple);
        }
    }

    public static Map<String, String> getTagPaths(MenuItem mi) {
        if (mi == null) {
            return null;
        }
        String ft = ".png";
        Service s = mi.getService();
        String miP = mi.getServiceMaskFilename();
        String srvP = s == null ? null : s.getServiceMaskFilename();
        boolean usm = s == null ? false : s.isFlagExist(0x8000000L);
        HashMap<String, String> tags = new HashMap<String, String>();
        MenuUtils.processTagPath(miP + "_XS" + ft, srvP + "_XS" + ft, usm, tags, "_XS");
        MenuUtils.processTagPath(miP + "_S" + ft, srvP + "_S" + ft, usm, tags, "_S");
        MenuUtils.processTagPath(miP + ft, srvP + ft, usm, tags, "default");
        MenuUtils.processTagPath(miP + "_L" + ft, srvP + "_L" + ft, usm, tags, "_L");
        MenuUtils.processTagPath(miP + "_XL" + ft, srvP + "_XL" + ft, usm, tags, "_XL");
        if (tags.isEmpty()) {
            return null;
        }
        return tags;
    }

    private static void processTagPath(String miP, String srvP, boolean usm, Map<String, String> tags, String key) {
        URL url;
        boolean miTagFileExist = false;
        boolean srvTagFileExist = false;
        if (miP != null && !miP.isEmpty()) {
            url = Locator.getUrl((String)("/gui/skin/{name}/img/" + miP), (boolean)false);
            boolean bl = miTagFileExist = url != null && FileUtil.checkFileExists((String)url.getPath());
        }
        if (srvP != null && !srvP.isEmpty()) {
            url = Locator.getUrl((String)("/gui/skin/{name}/img/" + srvP), (boolean)false);
            srvTagFileExist = url != null && FileUtil.checkFileExists((String)url.getPath());
        }
        String res = null;
        if (srvTagFileExist && (usm || !miTagFileExist)) {
            res = srvP;
        }
        if (res == null && miTagFileExist) {
            res = miP;
        }
        if (res != null && !res.isEmpty()) {
            tags.put(key, res);
        }
    }
}

