/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu;

import fxterm.core.menu.MenuVisitorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuKey;
import ru.softlogic.reference.menu.MenuKeyLang;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceLang;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.service.ServiceTypeLang;

public class MenuKeyVisitor
extends MenuVisitorAdapter {
    private final List<MenuKey> mKeys;
    private final Map<Integer, MenuItem> mItems;
    private final Map<Integer, ServiceType> sTypes;
    private final ServiceType start;
    private final ServiceType root;

    public MenuKeyVisitor(MenuKey[] mKeys, ServiceType root) {
        this.mKeys = Arrays.asList(mKeys);
        this.mItems = new HashMap<Integer, MenuItem>();
        this.sTypes = new HashMap<Integer, ServiceType>();
        this.start = new ServiceType();
        this.root = root;
        for (MenuKey mk : mKeys) {
            if (mk.getIdMenuItem() != null) {
                this.mItems.put(mk.getIdMenuItem(), null);
                continue;
            }
            if (mk.getIdServiceType() == null) continue;
            this.sTypes.put(mk.getIdServiceType(), null);
        }
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (this.mItems.containsKey(mi.getIdMenuItem())) {
            this.mItems.put(mi.getIdMenuItem(), mi);
        }
        return true;
    }

    @Override
    public boolean onGroup(ServiceType st) {
        if (this.sTypes.containsKey(st.getId())) {
            this.sTypes.put(st.getId(), st);
        }
        return true;
    }

    @Override
    public boolean onEnd() {
        ArrayList<ServiceType> types = new ArrayList<ServiceType>();
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        for (int i = 0; i < this.mKeys.size(); ++i) {
            ServiceType st;
            MenuKey mk = this.mKeys.get(i);
            if (mk.getIdMenuItem() != null) {
                if (this.mItems.get(mk.getIdMenuItem()) == null) continue;
                MenuItem mi = new MenuItem(this.mItems.get(mk.getIdMenuItem()));
                mi.setSortOrder((short)i);
                mi.setService(new Service(mi.getService()));
                mi.getService().setName(mk.getName());
                Optional.ofNullable(mk.getLogo()).ifPresent(arg_0 -> ((Service)mi.getService()).setImage(arg_0));
                mi.getService().setLangs(mk.getLangs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ServiceLang(((MenuKeyLang)e.getValue()).getLang(), ((MenuKeyLang)e.getValue()).getName(), ((MenuKeyLang)e.getValue()).getName(), ((MenuKeyLang)e.getValue()).getName(), ((MenuKeyLang)e.getValue()).getName()))));
                items.add(mi);
                continue;
            }
            if (mk.getIdServiceType() != null) {
                if (this.sTypes.get(mk.getIdServiceType()) == null) continue;
                st = new ServiceType(this.sTypes.get(mk.getIdServiceType()));
                if (mk.isFlagExist((short)1)) {
                    st.setFlags((short)(st.getFlags() | 1));
                }
                st.setSortOrder((short)i);
                st.setName(mk.getName());
                if (mk.getScreenType() != null) {
                    st.setScreenType(mk.getScreenType());
                }
                Optional.ofNullable(mk.getLogo()).ifPresent(arg_0 -> ((ServiceType)st).setImage(arg_0));
                st.setLangs(mk.getLangs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ServiceTypeLang(((MenuKeyLang)e.getValue()).getLang(), ((MenuKeyLang)e.getValue()).getName(), ((MenuKeyLang)e.getValue()).getName()))));
                types.add(st);
                continue;
            }
            st = new ServiceType(this.root);
            st.setSortOrder((short)i);
            st.setName(mk.getName());
            st.setImage(mk.getLogo());
            if (mk.getScreenType() != null) {
                st.setScreenType(mk.getScreenType());
            }
            st.setLangs(mk.getLangs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ServiceTypeLang(((MenuKeyLang)e.getValue()).getLang(), ((MenuKeyLang)e.getValue()).getName(), ((MenuKeyLang)e.getValue()).getName()))));
            types.add(st);
        }
        this.start.setMenuItems((MenuItem[])items.stream().toArray(MenuItem[]::new));
        this.start.setTypes((ServiceType[])types.stream().toArray(ServiceType[]::new));
        return false;
    }

    public ServiceType getStartMenu() {
        return this.start;
    }
}

