/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu;

import fxterm.core.menu.MenuVisitorAdapter;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.reference.menu.MenuItem;

public class MenuByBarcodeVisitor
extends MenuVisitorAdapter {
    private List<MenuItem> items;
    private String barcode;

    public MenuByBarcodeVisitor(String barcode) {
        if (barcode == null) {
            throw new NullPointerException();
        }
        this.barcode = barcode;
        this.items = new LinkedList<MenuItem>();
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        String barcodePrefix = mi.getService().getBarcodePrefix();
        if (barcodePrefix != null && !barcodePrefix.trim().isEmpty()) {
            try {
                if (this.barcode.matches(barcodePrefix)) {
                    this.items.add(mi);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public List<MenuItem> getItems() {
        return this.items;
    }
}

