/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.menu;

import fxterm.core.menu.ComplexMenuItem;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.MenuVisitorAdapter;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.ButtonStatus;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.service.ServiceType;

public class HotVisitorNg
extends MenuVisitorAdapter {
    private final int maxCount;
    private final boolean addToMaxCount;
    private final List<ComplexMenuItem> items;
    private final List<ServiceType> types;

    public HotVisitorNg(int maxCount, boolean addToMaxCount) {
        this.maxCount = maxCount;
        this.addToMaxCount = addToMaxCount;
        this.items = new LinkedList<ComplexMenuItem>();
        List hotItems = References.getHotItems();
        if (hotItems != null) {
            for (MenuItem mi : hotItems) {
                this.process(mi);
            }
        }
        this.types = new LinkedList<ServiceType>();
        List hotGroups = References.getHotGroups();
        if (hotGroups != null) {
            this.types.addAll(hotGroups);
        }
    }

    @Override
    public boolean onMenuItem(MenuItem mi) {
        if (this.isObtained()) {
            return false;
        }
        if (mi.getHotkeyPosition() != null) {
            return true;
        }
        this.process(mi);
        return !this.isObtained();
    }

    @Override
    public boolean onGroup(ServiceType st) {
        return !this.isObtained();
    }

    private void process(MenuItem menuItem) {
        MenuItemState state = MenuUtils.getState(menuItem);
        ComplexMenuItem cmi = new ComplexMenuItem(menuItem, state);
        if (state.getButtonStatus() != ButtonStatus.Hidden && !this.items.contains(cmi)) {
            this.items.add(new ComplexMenuItem(menuItem, state));
        }
    }

    private boolean isObtained() {
        return !this.addToMaxCount || this.items.size() + this.types.size() >= this.maxCount;
    }

    @Override
    public boolean onEnd() {
        return false;
    }

    @Override
    public boolean processGroup(ServiceType st) {
        return !st.getName().startsWith("#") && !st.isHidden();
    }

    public List<ComplexMenuItem> getItems() {
        return this.items;
    }

    public List<ServiceType> getTypes() {
        return this.types;
    }
}

