/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.launcher;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.Launcher;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ServiceLang;

public class WarningMenuChain
implements LaunchChain {
    private LaunchChain next;
    private final Logger log = LoggerId.PAY;

    public WarningMenuChain(LaunchChain next) {
        if (next == null) {
            throw new NullPointerException("LaunchChain is not set");
        }
        this.next = next;
    }

    @Override
    public void launch(final MenuItem menuItem, final Map<String, Object> initData, final NewKeeper2 keeper) {
        this.log.debug((Object)"Process warning handler");
        ServiceLang sl = Session.getServiceLang();
        if (sl.getWarning() != null && !sl.getWarning().trim().isEmpty()) {
            this.log.info((Object)("Show warning: " + sl.getWarning()));
            Dialog.show((String)"module/menu/warning_message", (DialogListener)new DialogListener(){

                public void onAction(int actionId) {
                    if (actionId == 0) {
                        WarningMenuChain.this.log.info((Object)"Confirmed");
                        WarningMenuChain.this.next.launch(menuItem, initData, keeper);
                    } else {
                        WarningMenuChain.this.log.info((Object)"Not confirmed. Break");
                        Launcher.exit(menuItem, keeper);
                    }
                }
            });
        } else {
            this.next.launch(menuItem, initData, keeper);
        }
    }
}

