/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.launcher;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.Launcher;
import fxterm.core.state.StateFacade;
import fxterm.core.state.TerminalState;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.reference.References;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.PointOptions;

public class PrinterMenuChain
implements LaunchChain {
    private final LaunchChain next;
    private final Logger log = LoggerId.PAY;

    public PrinterMenuChain(LaunchChain next) {
        if (next == null) {
            throw new NullPointerException("LaunchChain is not set");
        }
        this.next = next;
    }

    @Override
    public void launch(final MenuItem menuItem, final Map<String, Object> initData, final NewKeeper2 keeper) {
        this.log.debug((Object)"Process printer handler");
        TerminalState terminalStatus = StateFacade.getState();
        this.log.debug((Object)("Terminal state: " + terminalStatus));
        Session.setPrinterError((terminalStatus.getWarningMask() & 1) != 0);
        if ((terminalStatus.getWarningMask() & 1) != 0) {
            this.log.info((Object)("Paper required: " + menuItem.getService().getPaperRequire()));
            if (menuItem.getService().getPaperRequire() == 1) {
                this.log.error((Object)"Payment can not be processed");
                Dialog.show((String)"module/menu/error_paper");
                Launcher.exit(menuItem, keeper);
                return;
            }
            if (menuItem.getService().getPaperRequire() == 0) {
                PointOptions po = References.getPointOptions();
                if (po == null || po.getPaperWarning() == 1) {
                    this.log.info((Object)"Ask user");
                    Session.setItem("prn_error_confirm", Boolean.TRUE);
                    Dialog.show((String)"module/menu/warning_paper", (DialogListener)new DialogListener(){

                        public void onAction(int actionId) {
                            if (actionId == 0) {
                                PrinterMenuChain.this.log.info((Object)"Confirmed");
                                PrinterMenuChain.this.next.launch(menuItem, initData, keeper);
                            } else {
                                PrinterMenuChain.this.log.info((Object)"Not confirmed. Break");
                                Launcher.exit(menuItem, keeper);
                            }
                        }
                    });
                    return;
                }
                Session.setItem("prn_error_confirm", Boolean.FALSE);
                this.log.info((Object)"Go to pay without question");
            }
        }
        this.next.launch(menuItem, initData, keeper);
    }
}

