/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.launcher;

import fxterm.app.id.LoggerId;
import fxterm.app.plt2.EntryPoint;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.CashAccMenuChain;
import fxterm.core.launcher.DelayMenuChain;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.PrinterMenuChain;
import fxterm.core.launcher.WarningMenuChain;
import fxterm.core.menu.GroupByMenuItemVisitor;
import fxterm.core.menu.MenuUtils;
import fxterm.core.menu.VisitMenuCounter;
import fxterm.module.Environment;
import fxterm.module.EnvironmentFactory;
import fxterm.module.Pack;
import fxterm.module.PackUtility;
import fxterm.module.input.ModuleCreateException;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import fxterm.utils.FormatUtils;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.cash.Sum;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.service.comission.SumResult;

public class Launcher {
    private static final LaunchChain chain;
    private static final Logger log;
    private static EntryPoint entryPoint;

    public static void setEntryPoint(EntryPoint entryPoint) {
        Launcher.entryPoint = entryPoint;
    }

    public static void toPreviousState() {
        entryPoint.toPreviosState();
    }

    public static void open(MenuItem menuItem) {
        if (Session.getPayEnv().getKeeper().isEmpty()) {
            Launcher.open(menuItem, null, null);
        } else {
            Launcher.open(menuItem, null, Session.getPayEnv().getKeeper());
        }
    }

    public static void open(MenuItem menuItem, Map<String, Object> data, NewKeeper2 keeper) {
        try {
            log.info((Object)"\n\n");
            log.info((Object)"-------------------------------------------------------------------------------");
            log.info((Object)"Launch menu item");
            log.info((Object)("    Service     : " + FormatUtils.srvToString(menuItem.getService())));
            log.info((Object)("    Commission  : " + FormatUtils.commToString(menuItem.getCommission())));
            log.info((Object)("    Den. profile: " + menuItem.getCashUnitProfile()));
            log.info((Object)("    Input data  : " + data));
            log.info((Object)("    Input keeper: " + keeper));
            VisitMenuCounter.increment();
            GroupByMenuItemVisitor gbmiv = new GroupByMenuItemVisitor(menuItem);
            MenuUtils.processMenu(gbmiv);
            Session.setServiceType(gbmiv.getServiceType());
            Session.setSelectedItem(menuItem);
            chain.launch(menuItem, data, keeper);
        }
        catch (Throwable ex) {
            log.error((Object)"Unknown error process request", ex);
            Dialog.show((String)"module/menu/error_create");
            GuiNotifier.notifyError((Throwable)ex);
            Session.resetSession();
            entryPoint.toPreviosState();
        }
    }

    public static void exit(MenuItem menuItem, NewKeeper2 keeper) {
        if (keeper != null && !keeper.isEmpty()) {
            log.info((Object)"Keeper is not empty");
            Launcher.processChange(menuItem);
        } else {
            Session.resetSession();
            Launcher.toPreviousState();
        }
    }

    private static void processChange(MenuItem menuItem) {
        NewKeeper2 kpr = Session.getPayEnv().getKeeper();
        log.info((Object)("Process change, keeper=" + kpr));
        try {
            Environment env = EnvironmentFactory.getInstance().create(menuItem, Session.getLocale());
            Pack pack = new Pack(Session.getPayEnv().getPack());
            env.setPack(pack);
            kpr.setSumOut(FinUtils.createVoidSum());
            PackUtility.cancelPack(pack);
            Session.getPaymentEndingState().setCancel(true);
            env.getPack().setPaymentType(2);
            env.getPack().setPaybackType(0);
            env.getModules().getBeforePayoutModule().startPayout(env);
        }
        catch (ModuleCreateException ex) {
            log.error((Object)"Can't create module", (Throwable)ex);
            Dialog.show((String)"module/menu/error_create");
            GuiNotifier.notifyError((Throwable)ex);
            Session.resetSession();
            entryPoint.toPreviosState();
        }
    }

    static {
        log = LoggerId.PAY;
        LocalLaucher local = new LocalLaucher();
        WarningMenuChain warning = new WarningMenuChain(local);
        PrinterMenuChain printer = new PrinterMenuChain(warning);
        DelayMenuChain delay = new DelayMenuChain(printer);
        chain = new CashAccMenuChain(delay);
    }

    private static class LocalLaucher
    implements LaunchChain {
        private LocalLaucher() {
        }

        @Override
        public void launch(MenuItem menuItem, Map<String, Object> initData, NewKeeper2 keeper) {
            log.info((Object)("Provider type: " + menuItem.getService().getProviderType()));
            try {
                Sum sum;
                Sum s0 = FinUtils.createVoidSum();
                NewKeeper2 kpr = Session.getPayEnv().getKeeper();
                Environment environment = EnvironmentFactory.getInstance().create(menuItem, Session.getLocale());
                Sum out = kpr.getOut() != null ? kpr.getOut() : FinUtils.createVoidSum();
                Sum in = kpr.getIncome() != null ? kpr.getIncome() : FinUtils.createVoidSum();
                Pack pack = Session.getPayEnv().getPack();
                if (!(pack == null || (sum = in.add(out)).isEmpty() && keeper != null)) {
                    pack.setSumResult(new SumResult(s0, sum, s0, s0, s0, s0, null));
                    environment.getPack().setChangeDate(pack.getDate());
                }
                if (!out.isEmpty()) {
                    kpr.setIncome(in.add(out));
                }
                kpr.setSumOut(FinUtils.createVoidSum());
                if (kpr.isEmpty()) {
                    kpr.reset(Session.getInCurrency());
                } else if (keeper == null) {
                    kpr.resetCardAndCashInfo();
                }
                Session.getPayEnv().setLastKeeper(null);
                environment.setInitData(initData);
                environment.getModules().getLoadPaymentTemplateModule().start(environment);
            }
            catch (ModuleCreateException ex) {
                log.error((Object)"Can't create module", (Throwable)ex);
                Dialog.show((String)"module/menu/error_create");
                GuiNotifier.notifyError((Throwable)ex);
                Session.resetSession();
                entryPoint.toPreviosState();
            }
            catch (Throwable ex) {
                log.error((Object)"Unknown error process request", ex);
                Dialog.show((String)"module/menu/error_create");
                GuiNotifier.notifyError((Throwable)ex);
                Session.resetSession();
                entryPoint.toPreviosState();
            }
        }
    }
}

