/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.launcher;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.Launcher;
import fxterm.core.menu.MenuUtils;
import fxterm.session.Session;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;

public class DelayMenuChain
implements LaunchChain {
    private LaunchChain next;
    private final Logger log = LoggerId.PAY;

    public DelayMenuChain(LaunchChain next) {
        if (next == null) {
            throw new NullPointerException("LaunchChain is not set");
        }
        this.next = next;
    }

    @Override
    public void launch(final MenuItem menuItem, final Map<String, Object> initData, final NewKeeper2 keeper) {
        this.log.debug((Object)"Process delay handler");
        MenuItemState mis = MenuUtils.getState(menuItem);
        if (mis != null && mis.isDelay()) {
            this.log.info((Object)"Show message about payment delay");
            Dialog.show((String)"module/menu/warning_delay", (DialogListener)new DialogListener(){

                public void onAction(int actionId) {
                    if (actionId == 0) {
                        DelayMenuChain.this.log.info((Object)"Confirmed");
                        Session.setItem("pay_delay", Boolean.TRUE);
                        DelayMenuChain.this.next.launch(menuItem, initData, keeper);
                    } else {
                        DelayMenuChain.this.log.info((Object)"Not confirmed. Break");
                        Launcher.exit(menuItem, keeper);
                    }
                }
            });
        } else {
            Session.setItem("pay_delay", Boolean.FALSE);
            this.next.launch(menuItem, initData, keeper);
        }
    }
}

