/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.launcher;

import fxterm.app.FxEnv;
import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.CashManager;
import fxterm.core.hdw.bvr.oper.NewKeeper2;
import fxterm.core.launcher.LaunchChain;
import fxterm.core.launcher.Launcher;
import fxterm.core.state.StateFacade;
import fxterm.core.state.TerminalState;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import ru.softlogic.reference.menu.MenuItem;

public class CashAccMenuChain
implements LaunchChain {
    private static final Logger log = LoggerId.PAY;
    private final LaunchChain next;

    public CashAccMenuChain(LaunchChain next) {
        this.next = Objects.requireNonNull(next, "LaunchChain is not set");
    }

    @Override
    public void launch(MenuItem menuItem, Map<String, Object> initData, NewKeeper2 keeper) {
        log.debug((Object)"Process cash acceptor handler");
        if (this.checkWarning(menuItem, initData, keeper) && this.checkAllowedDenomination(menuItem, initData, keeper)) {
            this.next.launch(menuItem, initData, keeper);
        }
    }

    private boolean checkWarning(MenuItem menuItem, Map<String, Object> initData, NewKeeper2 keeper) {
        TerminalState terminalStatus = StateFacade.getState();
        log.debug((Object)("Terminal state: " + terminalStatus));
        if ((terminalStatus.getWarningMask() & 2) != 0) {
            log.info((Object)"Cash acceptor in error, show dialog");
            Dialog.show((String)"module/menu/warning_cashacc", actionId -> {
                if (actionId == 0) {
                    log.info((Object)"Confirmed");
                    this.next.launch(menuItem, initData, keeper);
                } else {
                    log.info((Object)"Not confirmed. Break");
                    Launcher.exit(menuItem, keeper);
                }
            });
            return false;
        }
        return true;
    }

    private boolean checkAllowedDenomination(MenuItem menuItem, Map<String, Object> initData, NewKeeper2 keeper) {
        String inCurrency;
        CashManager cashManager = FxEnv.getCashManager();
        boolean currencyAvailable = cashManager.currencySupport(inCurrency = menuItem.getService().getInCurrency());
        if (!currencyAvailable) {
            if (FxEnv.getCardModuleHandler() != null && FxEnv.getCardModuleHandler().isReady()) {
                Dialog.show((String)"module/menu/warning_hdw_currency", actionId -> {
                    if (actionId == 0) {
                        log.info((Object)"Confirmed");
                        this.next.launch(menuItem, initData, keeper);
                    } else {
                        log.info((Object)"Not confirmed. Break");
                        Launcher.exit(menuItem, keeper);
                    }
                });
            } else {
                log.info((Object)"Cash acceptor does not support this currency, show dialog");
                Dialog.show((String)"module/menu/error_hdw_currency", actionId -> {
                    if (actionId == 0) {
                        log.info((Object)"Confirmed");
                        Launcher.exit(menuItem, keeper);
                    }
                });
            }
            return false;
        }
        return true;
    }
}

