/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.kkm;

import fxterm.app.id.LoggerId;
import java.io.IOException;
import java.util.Objects;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.KkmModule;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.PrintModule;
import ru.softlogic.hdw.dev.printer.ReportResult;
import ru.softlogic.hdw.dev.printer.kkm.KkmOperation;
import ru.softlogic.hdw.dev.printer.kkm.ReportResultListener;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public class KkmReportJob
implements PrinterJob {
    private final Logger log = LoggerId.PRINT;
    private final KkmOperation op;
    protected final ReportResultListener listener;

    public KkmReportJob(KkmOperation op, ReportResultListener listener) {
        this.op = Objects.requireNonNull(op, "Operaion is not null");
        this.listener = listener;
    }

    public void print(PrintModule printer) {
        block9: {
            this.log.info((Object)"Start report job");
            if (printer.getKkmModule() != null) {
                this.log.info((Object)"Printer has kkt module ");
                try {
                    KkmModule kkmModule = printer.getKkmModule();
                    ReportResult rr = null;
                    switch (this.op) {
                        case FormReportZMem: {
                            rr = kkmModule.formReportZMem();
                        }
                    }
                    this.log.info((Object)("result=" + rr));
                    if (this.listener != null) {
                        this.listener.onResult(rr);
                    }
                    break block9;
                }
                catch (IOException | PrintException ex) {
                    if (this.listener != null) {
                        this.listener.onFailure((Exception)ex);
                    }
                    break block9;
                }
            }
            if (this.listener != null) {
                this.listener.onUnsupport();
            }
        }
    }

    public String toString() {
        return "OperPrinterJob{}";
    }
}

