/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.kkm;

import fxterm.app.id.LoggerId;
import fxterm.module.CancelDialogListener;
import fxterm.session.Session;
import org.apache.log4j.Logger;
import plfx.shell2.dialog.Dialog;
import plfx.shell2.dialog.DialogListener;
import plfx.util.TerminalPlatform;
import ru.softlogic.hdw.dev.printer.ReportResult;
import ru.softlogic.hdw.dev.printer.kkm.ReportResultListener;

public class DefaultReportResultListener
implements ReportResultListener {
    private final Logger log = LoggerId.PRINT;

    public void onResult(ReportResult rr) {
        this.log.info((Object)("Result of receipt of the report: " + rr));
        TerminalPlatform.runLater(() -> {
            if (rr.isError()) {
                Session.setItem("kkm_message", rr.getMessage());
                Dialog.show((String)"action/reports/kkm_report_error", (DialogListener)new CancelDialogListener(null));
            }
        });
    }

    public void onFailure(Exception excptn) {
        this.log.info((Object)("Error of receipt of the report: " + excptn));
        TerminalPlatform.runLater(() -> {
            Session.setItem("kkm_message", excptn.getMessage());
            Dialog.show((String)"action/reports/kkm_report_exception", (DialogListener)new CancelDialogListener(null));
        });
    }

    public void onUnsupport() {
        this.log.info((Object)"Device not supported this option");
        TerminalPlatform.runLater(() -> Dialog.show((String)"action/reports/kkm_report_unsupport", (DialogListener)new CancelDialogListener(null)));
    }
}

