/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.wcm;

import fxterm.app.BaseDriverFactory;
import fxterm.app.PaylogicResources;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.webcam.WcmConfiguration;
import ru.softlogic.hdw.dev.webcam.WcmOptions;
import ru.softlogic.hdw.dev.webcam.Webcam;
import ru.softlogic.hdw.dev.webcam.WebcamDriver;
import ru.softlogic.hdw.dev.webcam.WebcamFactory;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.connector.ClientInterface;

public class WcmDriverFactory
extends BaseDriverFactory {
    public static Webcam createWebcam(WcmConfiguration wcmConf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (wcmConf != null) {
            if (wcmConf.isEnable()) {
                log.info((Object)("Try to create webcam driver, type=" + wcmConf.getType() + ", port=" + wcmConf.getPort()));
                try {
                    Logger l = WcmDriverFactory.createLogger("webcam", "add/dev-webcam");
                    WebcamDriver wd = WebcamFactory.createDriver((String)wcmConf.getType(), (SerialPort)wcmConf.getPort(), (WcmOptions)wcmConf.getOptions(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + wd.getThreads().size() + " thread(s)"));
                    Webcam w = wd.getWebcam();
                    w.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                    w.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    w.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    resources.getThreads().addAll(wd.getThreads());
                    WcmDriverFactory.setSensorListener((Device)w, clientInterface);
                    return wd.getWebcam();
                }
                catch (CreatingException ex) {
                    WcmDriverFactory.onCreatingError(clientInterface, (short)23, wcmConf.getType(), (Port)wcmConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Webcam is not active");
            }
        } else {
            log.info((Object)"Webcam section or options is not found");
        }
        return null;
    }
}

