/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.prt;

import fxterm.app.ApplicationException;
import fxterm.app.BaseDriverFactory;
import fxterm.app.PaylogicResources;
import fxterm.app.id.LoggerId;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.printer.PrinterFactory;
import ru.softlogic.hdw.dev.printer.PrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtConfiguration;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtOptions;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtConfiguration;
import ru.softlogic.hdw.dev.printer.kkm.KkmPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.PosPrtConfiguration;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.spooler.PrintSpoolerDriver;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.connector.ClientInterface;

public class PrtDriverFactory
extends BaseDriverFactory {
    private PrtDriverFactory() {
    }

    public static PrintSpooler createPrinter(PrtConfiguration conf, ClientInterface clientInterface, PaylogicResources resources) throws ApplicationException {
        log.info((Object)"-------------------------------------------------------------------------------");
        PrintSpoolerDriver psd = null;
        if (conf != null) {
            log.info((Object)("Try to create printer driver, type=" + conf.getPrtClass()));
            try {
                switch (conf.getPrtClass()) {
                    case "ipp": {
                        IppPrtConfiguration ic = conf.getIppPrtConfiguration();
                        psd = PrinterFactory.createIppDriver((String)ic.getName(), (IppPrtOptions)ic.getOptions(), (Logger)LoggerId.PRINT);
                        break;
                    }
                    case "pos": {
                        PosPrtConfiguration pc = conf.getPosPrtConfiguration();
                        psd = PrinterFactory.createPosDriver((String)pc.getType(), (Port)pc.getPort(), (PosPrtOptions)pc.getOptions(), (Logger)LoggerId.PRINT);
                        break;
                    }
                    case "kkm": {
                        KkmPrtConfiguration pc = conf.getKkmPrtConfiguration();
                        psd = PrinterFactory.createKkmDriver((String)pc.getType(), (SerialPort)pc.getPort(), (KkmPrtOptions)pc.getOptions(), (Logger)LoggerId.PRINT);
                        break;
                    }
                    default: {
                        throw new ApplicationException(5, "Wrong printer class: " + conf.getPrtClass());
                    }
                }
            }
            catch (CreatingException ex) {
                throw new ApplicationException(5, "Wrong printer class: " + conf.getPrtClass(), ex);
            }
        }
        if (psd == null) {
            psd = PrtDriverFactory.createFailurePrinter();
        }
        log.info((Object)("Driver create successfully and contains " + psd.getThreads().size() + " thread(s)"));
        PrintSpooler ps = psd.getPrintSpooler();
        ps.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
        ps.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
        ps.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
        resources.getThreads().addAll(psd.getThreads());
        return ps;
    }

    private static PrintSpoolerDriver createFailurePrinter() throws ApplicationException {
        try {
            return PrinterFactory.createFailureDriver((Logger)log);
        }
        catch (CreatingException ex1) {
            throw new ApplicationException(5, "Error on creating printer", ex1);
        }
    }
}

