/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.prt;

import fxterm.core.hdw.bvr.col.CashCollection;
import fxterm.core.hdw.prt.CollectionPrinterJob;
import fxterm.core.hdw.prt.CommonPrinterJob;
import fxterm.core.hdw.prt.CustomPrinterJob;
import fxterm.core.hdw.prt.DiagPrinterJob;
import fxterm.core.hdw.prt.MultiCollectionPrinterJob;
import fxterm.session.Session;
import fxterm.utils.FinUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.References;
import ru.softlogic.reference.adv.CheckAdv;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;

public class PrnUtils {
    public static List<PrinterJob> createPrinterJob(Operation operation, boolean printByOne) {
        ArrayList<PrinterJob> jobs = new ArrayList();
        boolean useDeps = false;
        if (printByOne || !(operation instanceof GroupOperation)) {
            Service srv = Session.getService();
            String sr = srv.getCheckRender();
            String pr = null;
            PointOptions po = References.getPointOptions();
            if (po != null) {
                pr = po.getCheckRender();
                useDeps = po.isUseFiscalDepartments();
            }
            String advContent = PrnUtils.getLocaleAdvContent(PrnUtils.extractCheckAdv(srv.getId()), Session.getLocale().getLanguage());
            Session.setItem("adv", advContent);
            jobs.add(new CommonPrinterJob(PrnUtils.filterOperation(operation), PrnUtils.filterData(Session.getData()), Session.getLocale(), sr != null && !sr.isEmpty() ? sr : pr, !srv.isFlagExist(512L), useDeps));
        } else {
            List<Operation> operations = PrnUtils.convertGroupToSingleList((GroupOperation)operation);
            jobs = operations.stream().map(op -> PrnUtils.createPrinterJob(op, printByOne)).filter(jobList -> jobList.size() == 1).map(jobList -> (PrinterJob)jobList.get(0)).collect(Collectors.toList());
        }
        return jobs;
    }

    private static List<Operation> convertGroupToSingleList(GroupOperation go) {
        LinkedList<Operation> ops = new LinkedList<Operation>();
        boolean isFirst = true;
        Sum s0 = FinUtils.createVoidSum();
        Sum cashSum = go.getSumResult().getCash();
        Sum commAdd = FinUtils.createVoidSum();
        Sum commTotal = go.getChildOperations().stream().map(ChildOperation::getCommission).filter(com -> com != null).reduce(s0, Sum::add);
        if (go.getSumResult().getCommission().compareTo(commTotal) > 0) {
            commAdd = go.getSumResult().getCommission().sub(commTotal);
        }
        for (ChildOperation co : go.getChildOperations()) {
            Operation op = new Operation();
            op.setFeHash(go.getFeHash());
            op.setService(go.getService());
            op.setCommission(go.getCommission());
            op.setIdOperation(co.getIdOperation() == null ? 0 : co.getIdOperation());
            op.setCheckNumber(co.getCheckNumber() == null ? 0 : co.getCheckNumber());
            op.setPaymentTool(go.getPaymentTool());
            op.getInputElements().putAll(co.getInputElements());
            op.getForm().putAll(co.getForm());
            op.getViews().putAll(co.getViews());
            op.getTitles().putAll(co.getTitles());
            op.setDate(go.getDate());
            op.setChange(go.getChange());
            Sum comm = co.getCommission() == null ? FinUtils.createVoidSum() : co.getCommission();
            Sum change = null;
            if (isFirst) {
                op.setPinCode(go.getPinCode());
                op.setPinCodeNominal(go.getPinCodeNominal());
                change = go.getSumResult().getChange();
                comm = comm.add(commAdd);
                isFirst = false;
            } else {
                change = FinUtils.createVoidSum();
            }
            Sum in = co.getSumOutcome().add(comm).add(change);
            Sum cash = in.compareTo(cashSum) <= 0 ? new Sum(in) : new Sum(cashSum);
            cashSum = cashSum.sub(cash);
            Sum cashless = in.sub(cash);
            Keeper keeper = new Keeper();
            keeper.addCashBackCard(new CashBackCard(0, in));
            op.setKeeper(keeper);
            op.setSumResult(new SumResult(cash, cashless, co.getSumOutcome(), co.getSumOutcome(), comm, change, null));
            ops.add(op);
        }
        return ops;
    }

    public static PrinterJob createCustomPrinterJob(String templateName, Map<String, Object> data) {
        Map<String, Object> sd = Session.getData();
        sd.put("custom", data);
        return new CustomPrinterJob(sd, Session.getLocale(), templateName);
    }

    public static PrinterJob createPrinterJob(CashCollection collection) {
        PointOptions po = References.getPointOptions();
        return new CollectionPrinterJob(collection, Session.getData(), Session.getLocale(), po != null ? po.getInkassRender() : null);
    }

    public static PrinterJob createPrinterJob(List<CashCollection> collections) {
        PointOptions po = References.getPointOptions();
        return new MultiCollectionPrinterJob(collections, Session.getData(), Session.getLocale(), po != null ? po.getInkassRender() : null);
    }

    public static PrinterJob createPrinterJob(String template, Map<String, Object> data) {
        return new CustomPrinterJob(data, Session.getLocale(), template);
    }

    public static PrinterJob createDiagPrinterJob() {
        return new DiagPrinterJob(Session.getLocale());
    }

    private static CheckAdv extractCheckAdv(int idService) {
        CheckAdv[] advs = References.getCheckAdvs();
        if (advs == null) {
            return null;
        }
        if (advs.length == 1 && advs[0].getId() == 0) {
            return null;
        }
        int weight = 0;
        for (CheckAdv adv : advs) {
            if (adv.getId() <= 0 || adv.getWeight() <= 0 || adv.getIdService() != null && adv.getIdService() != idService || adv.getContent() == null || adv.getContent().isEmpty()) continue;
            weight += adv.getWeight();
        }
        if (weight == 0) {
            return null;
        }
        Random rnd = new Random();
        int value = rnd.nextInt(weight) + 1;
        weight = 0;
        for (CheckAdv adv : advs) {
            if (adv.getId() <= 0 || adv.getWeight() <= 0 || adv.getIdService() != null && adv.getIdService() != idService || adv.getContent() == null || adv.getContent().isEmpty() || (weight += adv.getWeight()) < value) continue;
            return adv;
        }
        return null;
    }

    private static String getLocaleAdvContent(CheckAdv adv, String language) {
        if (adv == null) {
            return "";
        }
        String res = (String)adv.getLangs().get(language);
        if (res == null || res.isEmpty()) {
            res = adv.getContent();
        }
        return res;
    }

    private static Map<String, Object> filterData(Map<String, Object> data) {
        Object obj = data.get("operation");
        if (obj instanceof Operation) {
            data.put("operation", PrnUtils.filterOperation((Operation)obj));
        }
        return data;
    }

    private static Operation filterOperation(Operation o) {
        if (o instanceof GroupOperation) {
            return PrnUtils.filterOperation((GroupOperation)o);
        }
        Operation op = new Operation(o);
        for (InputElement ie : o.getInputElements().values()) {
            if (!ie.hasFlag(2)) continue;
            op.getInputElements().remove(ie.getKey());
            op.getForm().remove(ie.getKey());
            op.getViews().remove(ie.getKey());
            op.getTitles().remove(ie.getKey());
        }
        return op;
    }

    private static Operation filterOperation(GroupOperation o) {
        List chop = o.getChildOperations();
        if (chop == null || chop.isEmpty()) {
            return o;
        }
        LinkedList<ChildOperation> clone = new LinkedList<ChildOperation>();
        for (ChildOperation cld : chop) {
            clone.add(new ChildOperation(cld));
        }
        GroupOperation go = new GroupOperation((Operation)o);
        go.setChildOperations(new LinkedList(clone));
        go.setSingleCheck(o.isSingleCheck());
        for (int i = 0; i < chop.size(); ++i) {
            ChildOperation cld = (ChildOperation)go.getChildOperations().get(i);
            for (InputElement ie : ((ChildOperation)chop.get(i)).getInputElements().values()) {
                if (!ie.hasFlag(2)) continue;
                cld.getInputElements().remove(ie.getKey());
                cld.getForm().remove(ie.getKey());
                cld.getViews().remove(ie.getKey());
                cld.getTitles().remove(ie.getKey());
            }
        }
        return go;
    }

    public static GroupOperation processTotalComm(GroupOperation go) {
        Sum commTotal = FinUtils.createVoidSum();
        for (ChildOperation co : go.getChildOperations()) {
            if (co.getCommission() == null) continue;
            commTotal = commTotal.add(co.getCommission());
        }
        if (!commTotal.isEmpty()) {
            SumResult sr = go.getSumResult();
            SumResult newSr = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut(), sr.getOutProv(), commTotal, sr.getChange(), sr.getDonate() == null ? FinUtils.createVoidSum() : sr.getDonate(), null);
            go.setSumResult(newSr);
        }
        return go;
    }
}

