/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.prt;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.col.CashCollection;
import fxterm.core.hdw.prt.CollectionLine;
import fxterm.core.hdw.prt.SimpleTextJob;
import fxterm.core.hdw.prt.TemplateExtractor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfile;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceClass;

public class MultiCollectionPrinterJob
extends SimpleTextJob {
    private final List<CashCollection> ccl;
    private final Map<String, Object> data;
    private final Locale locale;
    private final String template;
    private final Logger log = LoggerId.PRINT;

    public MultiCollectionPrinterJob(List<CashCollection> ccl, Map<String, Object> data, Locale locale, String template) {
        this.ccl = ccl;
        this.data = data;
        this.locale = locale;
        this.template = template;
    }

    @Override
    public String getImage(short prnClass) {
        boolean empty = true;
        HashMap<String, CollectionLine> totals = new HashMap<String, CollectionLine>();
        HashMap mclData = new HashMap();
        for (CashCollection cc : this.ccl) {
            HashMap<String, Object> dataCc = new HashMap<String, Object>();
            DenominationSet ds = cc.getDenominationSet();
            if (!ds.isEmpty()) {
                empty = false;
                dataCc.put("device", DeviceClass.asStr((short)cc.getBoxId().getDeviceClass()));
                dataCc.put("empty", false);
                String[] crs = ds.getCurrencies();
                dataCc.put("currencies", crs);
                HashMap lines = new HashMap();
                HashMap<String, CollectionLine> totalsCc = new HashMap<String, CollectionLine>();
                for (String curr : crs) {
                    Denomination[] dens = this.getDenominations(curr, cc);
                    if (dens == null) continue;
                    Map content = ds.getCounts(curr);
                    CollectionLine cl = (CollectionLine)totals.get(curr);
                    int sum = cl != null ? cl.getSum() : 0;
                    int count = cl != null ? cl.getCount() : 0;
                    LinkedList<CollectionLine> cls = new LinkedList<CollectionLine>();
                    int sumCc = 0;
                    int countCc = 0;
                    for (Denomination d : dens) {
                        int cnt = content.getOrDefault(d, 0);
                        int tot = d.getNominal() * cnt;
                        sumCc += tot;
                        countCc += cnt;
                        cls.add(new CollectionLine(d.getNominal(), SumFormatter.asStr((Denomination)d), cnt, tot, SumFormatter.asStr((Sum)new Sum(tot, d.getCurrency()))));
                    }
                    lines.put(curr, cls);
                    totalsCc.put(curr, new CollectionLine(0, "", countCc, sumCc, SumFormatter.asStr((Sum)new Sum(sumCc, curr))));
                    totals.put(curr, new CollectionLine(0, "", count, sum, SumFormatter.asStr((Sum)new Sum(sum, curr))));
                }
                dataCc.put("lines", lines);
                dataCc.put("totals", totalsCc);
            } else {
                dataCc.put("empty", true);
            }
            mclData.put("mc" + cc.getId(), dataCc);
        }
        if (empty) {
            this.data.put("empty", true);
        } else {
            this.data.put("mclData", mclData);
            this.data.put("totals", totals);
        }
        this.data.put("mcl", this.ccl);
        return TemplateExtractor.getImage(prnClass, "/res/templates/{0}/collect/", this.template, "collect{0}", "", this.locale, this.data);
    }

    public String toString() {
        return "MultiCollectionPrinterJob{}";
    }

    private Denomination[] getDenominations(String currency, CashCollection cc) {
        try {
            CashProfile cp = Cash.getCashProfile((String)currency);
            short dc = cc.getBoxId().getDeviceClass();
            if (dc == 3 || dc == 16) {
                return cp.getBills();
            }
            return cp.getCoins();
        }
        catch (CashProfileException ex) {
            this.log.error((Object)("Error on process currency " + currency), (Throwable)ex);
            return new Denomination[0];
        }
    }
}

