/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.prt;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.prt.TemplateExtractor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import ru.softlogic.hdw.dev.printer.Item;
import ru.softlogic.hdw.dev.printer.Operation;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.PrintModule;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public class CommonPrinterJob
implements PrinterJob {
    private final ru.softlogic.operation.Operation op;
    private final Map<String, Object> data;
    private final Locale locale;
    private final String template;
    private final boolean useFiscal;
    private final boolean useDeps;
    private final Logger log = LoggerId.PRINT;

    public CommonPrinterJob(ru.softlogic.operation.Operation op, Map<String, Object> data, Locale locale, String template, boolean useFiscal, boolean useDeps) {
        this.op = op;
        this.data = data;
        this.locale = locale;
        this.template = template;
        this.useFiscal = useFiscal;
        this.useDeps = useDeps;
    }

    public void print(PrintModule printer) {
        this.log.info((Object)"Start operation job");
        if (this.useFiscal && !this.op.getSumResult().getCash().isEmpty() && printer.getKkmModule() != null) {
            this.log.info((Object)"Use fiscal mode");
            LinkedList<Item> goods = new LinkedList<Item>();
            Item comm = null;
            if (this.useDeps) {
                goods.add(new Item((int)this.op.getService().getId(), this.op.getService().getPrintName(), this.op.getSumResult().getOut().getValue()));
                comm = new Item(0, "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f", this.op.getSumResult().getCommission().getValue());
            } else if (this.op.getSumResult().getOut().getValue() + this.op.getSumResult().getCommission().getValue() > 0) {
                goods.add(new Item((int)this.op.getService().getId(), this.op.getService().getPrintName(), this.op.getSumResult().getOut().getValue() + this.op.getSumResult().getCommission().getValue()));
            }
            int cashSum = this.op.getSumResult().getCash().getValue();
            int cashlessSum = 0;
            try {
                printer.getKkmModule().print(new Operation(goods, comm, this.getImage(printer.getPrinterClass()), cashSum, cashlessSum));
            }
            catch (IOException | PrintException ex) {
                this.log.error((Object)"Error on print", ex);
            }
        } else {
            this.log.info((Object)"Use simple mode");
            try {
                String image = this.getImage(printer.getPrinterClass());
                this.log.info((Object)"Done, print image");
                printer.print(image);
                this.log.info((Object)"Done");
            }
            catch (IOException | PrintException ex) {
                this.log.error((Object)"Error on print", ex);
            }
        }
    }

    public String getImage(short prnClass) {
        this.data.put("operation", this.op);
        this.data.put("cashless", this.op.getCashlessData());
        String image = TemplateExtractor.getImage(prnClass, "/res/templates/{0}/", this.template, "operation{0}", "", this.locale, this.data);
        if (image.trim().isEmpty()) {
            GuiNotifier.notifyProblemOnce((String)("Generated empty doc image " + this.template));
        }
        return image;
    }

    public String toString() {
        return "OperPrinterJob{ Operation:" + this.op + '}';
    }
}

