/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.prt;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.bvr.col.CashCollection;
import fxterm.core.hdw.prt.CollectionLine;
import fxterm.core.hdw.prt.SimpleTextJob;
import fxterm.core.hdw.prt.TemplateExtractor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Cash;
import ru.softlogic.hardware.currency.CashProfile;
import ru.softlogic.hardware.currency.CashProfileException;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.SumFormatter;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceClass;

public class CollectionPrinterJob
extends SimpleTextJob {
    private final CashCollection cc;
    private final Map<String, Object> data;
    private final Locale locale;
    private final String template;
    private final Logger log = LoggerId.PRINT;

    public CollectionPrinterJob(CashCollection cc, Map<String, Object> data, Locale locale, String template) {
        this.cc = cc;
        this.data = data;
        this.locale = locale;
        this.template = template;
    }

    @Override
    public String getImage(short prnClass) {
        DenominationSet ds = this.cc.getDenominationSet();
        if (!ds.isEmpty()) {
            this.data.put("device", DeviceClass.asStr((short)this.cc.getBoxId().getDeviceClass()));
            this.data.put("empty", false);
            String[] crs = ds.getCurrencies();
            this.data.put("currencies", crs);
            HashMap lines = new HashMap();
            HashMap<String, CollectionLine> totals = new HashMap<String, CollectionLine>();
            for (String curr : crs) {
                Denomination[] dens = this.getDenominations(curr);
                if (dens == null) continue;
                Map content = ds.getCounts(curr);
                LinkedList<CollectionLine> cls = new LinkedList<CollectionLine>();
                int sum = 0;
                int count = 0;
                for (Denomination d : dens) {
                    int cnt = content.getOrDefault(d, 0);
                    int tot = d.getNominal() * cnt;
                    sum += tot;
                    count += cnt;
                    cls.add(new CollectionLine(d.getNominal(), SumFormatter.asStr((Denomination)d), cnt, tot, SumFormatter.asStr((Sum)new Sum(tot, d.getCurrency()))));
                }
                lines.put(curr, cls);
                totals.put(curr, new CollectionLine(0, "", count, sum, SumFormatter.asStr((Sum)new Sum(sum, curr))));
            }
            this.data.put("lines", lines);
            this.data.put("totals", totals);
        } else {
            this.data.put("empty", true);
        }
        this.data.put("mc", this.cc);
        return TemplateExtractor.getImage(prnClass, "/res/templates/{0}/collect/", this.template, "collect{0}", "", this.locale, this.data);
    }

    public String toString() {
        return "CollectionPrinterJob{}";
    }

    private Denomination[] getDenominations(String currency) {
        try {
            CashProfile cp = Cash.getCashProfile((String)currency);
            short dc = this.cc.getBoxId().getDeviceClass();
            if (dc == 3 || dc == 16) {
                return cp.getBills();
            }
            return cp.getCoins();
        }
        catch (CashProfileException ex) {
            this.log.error((Object)("Error on process currency " + currency), (Throwable)ex);
            return new Denomination[0];
        }
    }
}

