/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.modem;

import fxterm.app.BaseDriverFactory;
import fxterm.app.PaylogicResources;
import fxterm.app.id.LoggerId;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import fxterm.core.hdw.SrvProblemListener;
import fxterm.core.net.ppp.DialupSystem;
import fxterm.core.net.ppp.UssdCheckTask;
import fxterm.core.net.ppp.UssdCheckTaskGenerator;
import fxterm.session.Session;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.base.Device;
import ru.softlogic.hdw.dev.modem.ModConfiguration;
import ru.softlogic.hdw.dev.modem.ModOptions;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemFactory;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.hdw.dev.watchdog.WatchDogDriver;
import ru.softlogic.hdw.dev.watchdog.WatchDogFactory;
import ru.softlogic.hdw.dev.watchdog.WdtConfiguration;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.modem.Operator;
import ru.softlogic.srv.connector.ClientInterface;

public class DialupDriverFactory
extends BaseDriverFactory {
    private DialupDriverFactory() {
    }

    public static WatchDog createWatchdog(WdtConfiguration conf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf != null) {
            log.info((Object)("Try to create watchdog, type=" + conf.getType() + ", port=" + conf.getPort()));
            try {
                WatchDogDriver wdd = WatchDogFactory.createDriver((String)conf.getType(), (SerialPort)conf.getPort(), (Logger)LoggerId.DIALUP);
                log.info((Object)("Driver create successfully and contains " + wdd.getThreads().size() + " thread(s)"));
                WatchDog wd = wdd.getWatchDog();
                wd.addDeviceProblemListener((DeviceProblemListener)new SrvProblemListener(clientInterface));
                wd.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                wd.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                resources.getThreads().addAll(wdd.getThreads());
                DialupDriverFactory.setSensorListener((Device)wd, clientInterface);
                return wd;
            }
            catch (CreatingException ex) {
                DialupDriverFactory.onCreatingError(clientInterface, (short)5, conf.getType(), (Port)conf.getPort(), (Exception)((Object)ex));
            }
        } else {
            log.info((Object)"Watchdog section is not found");
        }
        return null;
    }

    public static Modem createModem(ModConfiguration conf, ClientInterface clientInterface) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (conf != null && conf.isEnable()) {
            log.info((Object)("Try to create modem driver, type=" + conf.getType() + ", port=" + conf.getPort()));
            try {
                return ModemFactory.createModem((String)conf.getType(), (SerialPort)conf.getPort(), (ModOptions)conf.getOptions(), (Logger)LoggerId.DIALUP);
            }
            catch (CreatingException ex) {
                DialupDriverFactory.onCreatingError(clientInterface, (short)6, conf.getType(), (Port)conf.getPort(), (Exception)((Object)ex));
            }
        } else {
            log.info((Object)"Modem section or options is not found");
        }
        return null;
    }

    public static DialupSystem createDialupSystem(String dialupName, WatchDog watchDog, Modem modem, ClientInterface clientInterface, PaylogicResources resources, ScheduledExecutorService scheduler) {
        log.info((Object)"-------------------------------------------------------------------------------");
        log.info((Object)"Dial-up watcher");
        log.info((Object)("Necessary to control the dial-up connection: " + dialupName));
        if (dialupName != null && !dialupName.isEmpty()) {
            log.info((Object)"   Create control thread");
            DialupSystem ds = new DialupSystem(ManagerFactory.create(), dialupName, watchDog, modem);
            resources.getThreads().add(new Thread((Runnable)ds, "DialupSystem"));
            if (modem != null) {
                log.info((Object)"Add ussd check task");
                String ussd = modem.getModemOptions().getUssd();
                if (ussd != null) {
                    Session.setItem("modem_ussd", ussd);
                }
                scheduler.scheduleAtFixedRate(DialupDriverFactory._p(new UssdCheckTaskGenerator(ds, new UssdCheckTask(clientInterface))), 0L, 240L, TimeUnit.MINUTES);
            }
            return ds;
        }
        clientInterface.sendModemState(new ModemState(null, 0, new Operator(1, ""), null, null));
        return null;
    }
}

