/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.modem;

import fxterm.app.id.LoggerId;
import fxterm.core.hdw.modem.ModemJob;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.modem.Api;
import ru.softlogic.hdw.dev.modem.Modem;
import ru.softlogic.hdw.dev.modem.ModemException;
import ru.softlogic.hdw.dev.modem.OpenException;

public abstract class BaseModemJob
implements ModemJob {
    private final Logger log = LoggerId.DIALUP;
    private static final int ATTEMPT_COUNT = 2;
    private static final long ATTEMPT_PAUSE = 500L;
    private final Object lock = new Object();
    private Object result;
    private Exception error;
    private boolean taskDone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Modem modem) throws InterruptedException {
        try {
            modem.open();
            for (int i = 0; i < 2; ++i) {
                try {
                    this.log.info((Object)("Try to open device. Attempt " + i));
                    this.log.info((Object)"Done, init modem");
                    Api modemApi = modem.getApi();
                    this.log.info((Object)("Execute task: " + this.getClass().getSimpleName()));
                    this.result = this._execute(modemApi);
                    this.error = null;
                    break;
                }
                catch (Exception ex) {
                    this.log.error((Object)"Error on open modem port", (Throwable)ex);
                    this.error = ex;
                    Thread.sleep(500L);
                    continue;
                }
            }
        }
        catch (OpenException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            this.log.info((Object)"Try to close modem");
            modem.close();
            this.log.info((Object)"Close done");
        }
        this.taskDone = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    abstract Object _execute(Api var1) throws ModemException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws Exception {
        this.log.info((Object)("taskDone: " + this.taskDone));
        if (!this.taskDone) {
            Object object = this.lock;
            synchronized (object) {
                this.log.info((Object)"Wait result...");
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    this.log.info((Object)"...interrupted");
                    Thread.currentThread().interrupt();
                    throw ex;
                }
            }
        }
        if (this.error != null) {
            this.log.info((Object)("...exception. " + this.error.getMessage()));
            throw this.error;
        }
        this.log.info((Object)"...done");
        return this.result;
    }
}

