/*
 * Decompiled with CFR 0.152.
 */
package fxterm.core.hdw.cvd;

import fxterm.app.BaseDriverFactory;
import fxterm.app.FxEnvInit;
import fxterm.app.PaylogicResources;
import fxterm.core.hdw.CommonDeviceInfoListener;
import fxterm.core.hdw.SrvDeviceStateListener;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cvd.CardDispenser;
import ru.softlogic.hdw.dev.cvd.CardDispenserDriver;
import ru.softlogic.hdw.dev.cvd.CardDispenserFactory;
import ru.softlogic.hdw.dev.cvd.CvdConfiguration;
import ru.softlogic.hdw.dev.cvd.CvdOptions;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceStateListener;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.srv.connector.ClientInterface;

public class CvdDriverFactory
extends BaseDriverFactory {
    private CvdDriverFactory() {
    }

    public static void createCardDispenser(CvdConfiguration cvdConf, ClientInterface clientInterface, PaylogicResources resources) {
        log.info((Object)"-------------------------------------------------------------------------------");
        if (cvdConf != null && cvdConf.getOptions() != null) {
            if (cvdConf.isEnable()) {
                log.info((Object)("Try to create card vending dispenser, type=" + cvdConf.getType() + ", port=" + cvdConf.getPort()));
                try {
                    Logger l = CvdDriverFactory.createLogger("card-disp", "disp/card");
                    CardDispenserDriver cdd = CardDispenserFactory.createDriver((String)cvdConf.getType(), (SerialPort)cvdConf.getPort(), (CvdOptions)cvdConf.getOptions(), (Logger)l);
                    log.info((Object)("Driver create successfully and contains " + cdd.getThreads().size() + " thread(s)"));
                    CardDispenser cd = cdd.getCardDispenser();
                    cd.addDeviceInfoListener((DeviceInfoListener)new CommonDeviceInfoListener(clientInterface));
                    cd.addStateListener((DeviceStateListener)new SrvDeviceStateListener(clientInterface));
                    FxEnvInit.setCardDispenser(cd);
                    resources.getThreads().addAll(cdd.getThreads());
                }
                catch (CreatingException ex) {
                    CvdDriverFactory.onCreatingError(clientInterface, (short)15, cvdConf.getType(), (Port)cvdConf.getPort(), (Exception)((Object)ex));
                }
            } else {
                log.info((Object)"Card dispenser is not active");
            }
        } else {
            log.info((Object)"Card dispenser section or options is not found");
        }
    }
}

